/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source of the campaign
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<String> CUSTOMER_PROFILES_SEGMENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("customerProfilesSegmentArn")
            .getter(getter(Source::customerProfilesSegmentArn))
            .setter(setter(Builder::customerProfilesSegmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfilesSegmentArn").build())
            .build();

    private static final SdkField<EventTrigger> EVENT_TRIGGER_FIELD = SdkField.<EventTrigger> builder(MarshallingType.SDK_POJO)
            .memberName("eventTrigger").getter(getter(Source::eventTrigger)).setter(setter(Builder::eventTrigger))
            .constructor(EventTrigger::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrigger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_PROFILES_SEGMENT_ARN_FIELD, EVENT_TRIGGER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customerProfilesSegmentArn;

    private final EventTrigger eventTrigger;

    private final Type type;

    private Source(BuilderImpl builder) {
        this.customerProfilesSegmentArn = builder.customerProfilesSegmentArn;
        this.eventTrigger = builder.eventTrigger;
        this.type = builder.type;
    }

    /**
     * Returns the value of the CustomerProfilesSegmentArn property for this object.
     * 
     * @return The value of the CustomerProfilesSegmentArn property for this object.
     */
    public final String customerProfilesSegmentArn() {
        return customerProfilesSegmentArn;
    }

    /**
     * Returns the value of the EventTrigger property for this object.
     * 
     * @return The value of the EventTrigger property for this object.
     */
    public final EventTrigger eventTrigger() {
        return eventTrigger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerProfilesSegmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventTrigger());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(customerProfilesSegmentArn(), other.customerProfilesSegmentArn())
                && Objects.equals(eventTrigger(), other.eventTrigger());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("CustomerProfilesSegmentArn", customerProfilesSegmentArn())
                .add("EventTrigger", eventTrigger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerProfilesSegmentArn":
            return Optional.ofNullable(clazz.cast(customerProfilesSegmentArn()));
        case "eventTrigger":
            return Optional.ofNullable(clazz.cast(eventTrigger()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customerProfilesSegmentArn()} initialized to the given value.
     *
     * Sets the value of the CustomerProfilesSegmentArn property for this object.
     *
     * @param customerProfilesSegmentArn
     *        The new value for the CustomerProfilesSegmentArn property for this object.
     */
    public static Source fromCustomerProfilesSegmentArn(String customerProfilesSegmentArn) {
        return builder().customerProfilesSegmentArn(customerProfilesSegmentArn).build();
    }

    /**
     * Create an instance of this class with {@link #eventTrigger()} initialized to the given value.
     *
     * Sets the value of the EventTrigger property for this object.
     *
     * @param eventTrigger
     *        The new value for the EventTrigger property for this object.
     */
    public static Source fromEventTrigger(EventTrigger eventTrigger) {
        return builder().eventTrigger(eventTrigger).build();
    }

    /**
     * Create an instance of this class with {@link #eventTrigger()} initialized to the given value.
     *
     * Sets the value of the EventTrigger property for this object.
     *
     * @param eventTrigger
     *        The new value for the EventTrigger property for this object.
     */
    public static Source fromEventTrigger(Consumer<EventTrigger.Builder> eventTrigger) {
        EventTrigger.Builder builder = EventTrigger.builder();
        eventTrigger.accept(builder);
        return fromEventTrigger(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerProfilesSegmentArn", CUSTOMER_PROFILES_SEGMENT_ARN_FIELD);
        map.put("eventTrigger", EVENT_TRIGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * Sets the value of the CustomerProfilesSegmentArn property for this object.
         *
         * @param customerProfilesSegmentArn
         *        The new value for the CustomerProfilesSegmentArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfilesSegmentArn(String customerProfilesSegmentArn);

        /**
         * Sets the value of the EventTrigger property for this object.
         *
         * @param eventTrigger
         *        The new value for the EventTrigger property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrigger(EventTrigger eventTrigger);

        /**
         * Sets the value of the EventTrigger property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EventTrigger.Builder} avoiding the need
         * to create one manually via {@link EventTrigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventTrigger.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTrigger(EventTrigger)}.
         * 
         * @param eventTrigger
         *        a consumer that will call methods on {@link EventTrigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTrigger(EventTrigger)
         */
        default Builder eventTrigger(Consumer<EventTrigger.Builder> eventTrigger) {
            return eventTrigger(EventTrigger.builder().applyMutation(eventTrigger).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String customerProfilesSegmentArn;

        private EventTrigger eventTrigger;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            customerProfilesSegmentArn(model.customerProfilesSegmentArn);
            eventTrigger(model.eventTrigger);
        }

        public final String getCustomerProfilesSegmentArn() {
            return customerProfilesSegmentArn;
        }

        public final void setCustomerProfilesSegmentArn(String customerProfilesSegmentArn) {
            Object oldValue = this.customerProfilesSegmentArn;
            this.customerProfilesSegmentArn = customerProfilesSegmentArn;
            handleUnionValueChange(Type.CUSTOMER_PROFILES_SEGMENT_ARN, oldValue, this.customerProfilesSegmentArn);
        }

        @Override
        public final Builder customerProfilesSegmentArn(String customerProfilesSegmentArn) {
            Object oldValue = this.customerProfilesSegmentArn;
            this.customerProfilesSegmentArn = customerProfilesSegmentArn;
            handleUnionValueChange(Type.CUSTOMER_PROFILES_SEGMENT_ARN, oldValue, this.customerProfilesSegmentArn);
            return this;
        }

        public final EventTrigger.Builder getEventTrigger() {
            return eventTrigger != null ? eventTrigger.toBuilder() : null;
        }

        public final void setEventTrigger(EventTrigger.BuilderImpl eventTrigger) {
            Object oldValue = this.eventTrigger;
            this.eventTrigger = eventTrigger != null ? eventTrigger.build() : null;
            handleUnionValueChange(Type.EVENT_TRIGGER, oldValue, this.eventTrigger);
        }

        @Override
        public final Builder eventTrigger(EventTrigger eventTrigger) {
            Object oldValue = this.eventTrigger;
            this.eventTrigger = eventTrigger;
            handleUnionValueChange(Type.EVENT_TRIGGER, oldValue, this.eventTrigger);
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Source#type()
     */
    public enum Type {
        CUSTOMER_PROFILES_SEGMENT_ARN,

        EVENT_TRIGGER,

        UNKNOWN_TO_SDK_VERSION
    }
}
