/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Telephony Channel Subtype config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelephonyChannelSubtypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TelephonyChannelSubtypeConfig.Builder, TelephonyChannelSubtypeConfig> {
    private static final SdkField<Double> CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("capacity").getter(getter(TelephonyChannelSubtypeConfig::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<String> CONNECT_QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectQueueId").getter(getter(TelephonyChannelSubtypeConfig::connectQueueId))
            .setter(setter(Builder::connectQueueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectQueueId").build()).build();

    private static final SdkField<TelephonyOutboundMode> OUTBOUND_MODE_FIELD = SdkField
            .<TelephonyOutboundMode> builder(MarshallingType.SDK_POJO).memberName("outboundMode")
            .getter(getter(TelephonyChannelSubtypeConfig::outboundMode)).setter(setter(Builder::outboundMode))
            .constructor(TelephonyOutboundMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundMode").build()).build();

    private static final SdkField<TelephonyOutboundConfig> DEFAULT_OUTBOUND_CONFIG_FIELD = SdkField
            .<TelephonyOutboundConfig> builder(MarshallingType.SDK_POJO).memberName("defaultOutboundConfig")
            .getter(getter(TelephonyChannelSubtypeConfig::defaultOutboundConfig)).setter(setter(Builder::defaultOutboundConfig))
            .constructor(TelephonyOutboundConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultOutboundConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            CONNECT_QUEUE_ID_FIELD, OUTBOUND_MODE_FIELD, DEFAULT_OUTBOUND_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double capacity;

    private final String connectQueueId;

    private final TelephonyOutboundMode outboundMode;

    private final TelephonyOutboundConfig defaultOutboundConfig;

    private TelephonyChannelSubtypeConfig(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.connectQueueId = builder.connectQueueId;
        this.outboundMode = builder.outboundMode;
        this.defaultOutboundConfig = builder.defaultOutboundConfig;
    }

    /**
     * Returns the value of the Capacity property for this object.
     * 
     * @return The value of the Capacity property for this object.
     */
    public final Double capacity() {
        return capacity;
    }

    /**
     * Returns the value of the ConnectQueueId property for this object.
     * 
     * @return The value of the ConnectQueueId property for this object.
     */
    public final String connectQueueId() {
        return connectQueueId;
    }

    /**
     * Returns the value of the OutboundMode property for this object.
     * 
     * @return The value of the OutboundMode property for this object.
     */
    public final TelephonyOutboundMode outboundMode() {
        return outboundMode;
    }

    /**
     * Returns the value of the DefaultOutboundConfig property for this object.
     * 
     * @return The value of the DefaultOutboundConfig property for this object.
     */
    public final TelephonyOutboundConfig defaultOutboundConfig() {
        return defaultOutboundConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(connectQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(outboundMode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyChannelSubtypeConfig)) {
            return false;
        }
        TelephonyChannelSubtypeConfig other = (TelephonyChannelSubtypeConfig) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(connectQueueId(), other.connectQueueId())
                && Objects.equals(outboundMode(), other.outboundMode())
                && Objects.equals(defaultOutboundConfig(), other.defaultOutboundConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelephonyChannelSubtypeConfig").add("Capacity", capacity())
                .add("ConnectQueueId", connectQueueId()).add("OutboundMode", outboundMode())
                .add("DefaultOutboundConfig", defaultOutboundConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "connectQueueId":
            return Optional.ofNullable(clazz.cast(connectQueueId()));
        case "outboundMode":
            return Optional.ofNullable(clazz.cast(outboundMode()));
        case "defaultOutboundConfig":
            return Optional.ofNullable(clazz.cast(defaultOutboundConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("connectQueueId", CONNECT_QUEUE_ID_FIELD);
        map.put("outboundMode", OUTBOUND_MODE_FIELD);
        map.put("defaultOutboundConfig", DEFAULT_OUTBOUND_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyChannelSubtypeConfig, T> g) {
        return obj -> g.apply((TelephonyChannelSubtypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelephonyChannelSubtypeConfig> {
        /**
         * Sets the value of the Capacity property for this object.
         *
         * @param capacity
         *        The new value for the Capacity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Double capacity);

        /**
         * Sets the value of the ConnectQueueId property for this object.
         *
         * @param connectQueueId
         *        The new value for the ConnectQueueId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectQueueId(String connectQueueId);

        /**
         * Sets the value of the OutboundMode property for this object.
         *
         * @param outboundMode
         *        The new value for the OutboundMode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundMode(TelephonyOutboundMode outboundMode);

        /**
         * Sets the value of the OutboundMode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TelephonyOutboundMode.Builder} avoiding
         * the need to create one manually via {@link TelephonyOutboundMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyOutboundMode.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundMode(TelephonyOutboundMode)}.
         * 
         * @param outboundMode
         *        a consumer that will call methods on {@link TelephonyOutboundMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundMode(TelephonyOutboundMode)
         */
        default Builder outboundMode(Consumer<TelephonyOutboundMode.Builder> outboundMode) {
            return outboundMode(TelephonyOutboundMode.builder().applyMutation(outboundMode).build());
        }

        /**
         * Sets the value of the DefaultOutboundConfig property for this object.
         *
         * @param defaultOutboundConfig
         *        The new value for the DefaultOutboundConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundConfig(TelephonyOutboundConfig defaultOutboundConfig);

        /**
         * Sets the value of the DefaultOutboundConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TelephonyOutboundConfig.Builder} avoiding
         * the need to create one manually via {@link TelephonyOutboundConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyOutboundConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultOutboundConfig(TelephonyOutboundConfig)}.
         * 
         * @param defaultOutboundConfig
         *        a consumer that will call methods on {@link TelephonyOutboundConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultOutboundConfig(TelephonyOutboundConfig)
         */
        default Builder defaultOutboundConfig(Consumer<TelephonyOutboundConfig.Builder> defaultOutboundConfig) {
            return defaultOutboundConfig(TelephonyOutboundConfig.builder().applyMutation(defaultOutboundConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double capacity;

        private String connectQueueId;

        private TelephonyOutboundMode outboundMode;

        private TelephonyOutboundConfig defaultOutboundConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyChannelSubtypeConfig model) {
            capacity(model.capacity);
            connectQueueId(model.connectQueueId);
            outboundMode(model.outboundMode);
            defaultOutboundConfig(model.defaultOutboundConfig);
        }

        public final Double getCapacity() {
            return capacity;
        }

        public final void setCapacity(Double capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Double capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getConnectQueueId() {
            return connectQueueId;
        }

        public final void setConnectQueueId(String connectQueueId) {
            this.connectQueueId = connectQueueId;
        }

        @Override
        public final Builder connectQueueId(String connectQueueId) {
            this.connectQueueId = connectQueueId;
            return this;
        }

        public final TelephonyOutboundMode.Builder getOutboundMode() {
            return outboundMode != null ? outboundMode.toBuilder() : null;
        }

        public final void setOutboundMode(TelephonyOutboundMode.BuilderImpl outboundMode) {
            this.outboundMode = outboundMode != null ? outboundMode.build() : null;
        }

        @Override
        public final Builder outboundMode(TelephonyOutboundMode outboundMode) {
            this.outboundMode = outboundMode;
            return this;
        }

        public final TelephonyOutboundConfig.Builder getDefaultOutboundConfig() {
            return defaultOutboundConfig != null ? defaultOutboundConfig.toBuilder() : null;
        }

        public final void setDefaultOutboundConfig(TelephonyOutboundConfig.BuilderImpl defaultOutboundConfig) {
            this.defaultOutboundConfig = defaultOutboundConfig != null ? defaultOutboundConfig.build() : null;
        }

        @Override
        public final Builder defaultOutboundConfig(TelephonyOutboundConfig defaultOutboundConfig) {
            this.defaultOutboundConfig = defaultOutboundConfig;
            return this;
        }

        @Override
        public TelephonyChannelSubtypeConfig build() {
            return new TelephonyChannelSubtypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
