/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Default Telephony Outbound config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelephonyOutboundConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TelephonyOutboundConfig.Builder, TelephonyOutboundConfig> {
    private static final SdkField<String> CONNECT_CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectContactFlowId").getter(getter(TelephonyOutboundConfig::connectContactFlowId))
            .setter(setter(Builder::connectContactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectContactFlowId").build())
            .build();

    private static final SdkField<String> CONNECT_SOURCE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectSourcePhoneNumber").getter(getter(TelephonyOutboundConfig::connectSourcePhoneNumber))
            .setter(setter(Builder::connectSourcePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourcePhoneNumber").build())
            .build();

    private static final SdkField<AnswerMachineDetectionConfig> ANSWER_MACHINE_DETECTION_CONFIG_FIELD = SdkField
            .<AnswerMachineDetectionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("answerMachineDetectionConfig")
            .getter(getter(TelephonyOutboundConfig::answerMachineDetectionConfig))
            .setter(setter(Builder::answerMachineDetectionConfig))
            .constructor(AnswerMachineDetectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("answerMachineDetectionConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_CONTACT_FLOW_ID_FIELD,
            CONNECT_SOURCE_PHONE_NUMBER_FIELD, ANSWER_MACHINE_DETECTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectContactFlowId;

    private final String connectSourcePhoneNumber;

    private final AnswerMachineDetectionConfig answerMachineDetectionConfig;

    private TelephonyOutboundConfig(BuilderImpl builder) {
        this.connectContactFlowId = builder.connectContactFlowId;
        this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
        this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
    }

    /**
     * Returns the value of the ConnectContactFlowId property for this object.
     * 
     * @return The value of the ConnectContactFlowId property for this object.
     */
    public final String connectContactFlowId() {
        return connectContactFlowId;
    }

    /**
     * Returns the value of the ConnectSourcePhoneNumber property for this object.
     * 
     * @return The value of the ConnectSourcePhoneNumber property for this object.
     */
    public final String connectSourcePhoneNumber() {
        return connectSourcePhoneNumber;
    }

    /**
     * Returns the value of the AnswerMachineDetectionConfig property for this object.
     * 
     * @return The value of the AnswerMachineDetectionConfig property for this object.
     */
    public final AnswerMachineDetectionConfig answerMachineDetectionConfig() {
        return answerMachineDetectionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectContactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(connectSourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(answerMachineDetectionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyOutboundConfig)) {
            return false;
        }
        TelephonyOutboundConfig other = (TelephonyOutboundConfig) obj;
        return Objects.equals(connectContactFlowId(), other.connectContactFlowId())
                && Objects.equals(connectSourcePhoneNumber(), other.connectSourcePhoneNumber())
                && Objects.equals(answerMachineDetectionConfig(), other.answerMachineDetectionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelephonyOutboundConfig").add("ConnectContactFlowId", connectContactFlowId())
                .add("ConnectSourcePhoneNumber", connectSourcePhoneNumber())
                .add("AnswerMachineDetectionConfig", answerMachineDetectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectContactFlowId":
            return Optional.ofNullable(clazz.cast(connectContactFlowId()));
        case "connectSourcePhoneNumber":
            return Optional.ofNullable(clazz.cast(connectSourcePhoneNumber()));
        case "answerMachineDetectionConfig":
            return Optional.ofNullable(clazz.cast(answerMachineDetectionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectContactFlowId", CONNECT_CONTACT_FLOW_ID_FIELD);
        map.put("connectSourcePhoneNumber", CONNECT_SOURCE_PHONE_NUMBER_FIELD);
        map.put("answerMachineDetectionConfig", ANSWER_MACHINE_DETECTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyOutboundConfig, T> g) {
        return obj -> g.apply((TelephonyOutboundConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelephonyOutboundConfig> {
        /**
         * Sets the value of the ConnectContactFlowId property for this object.
         *
         * @param connectContactFlowId
         *        The new value for the ConnectContactFlowId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectContactFlowId(String connectContactFlowId);

        /**
         * Sets the value of the ConnectSourcePhoneNumber property for this object.
         *
         * @param connectSourcePhoneNumber
         *        The new value for the ConnectSourcePhoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectSourcePhoneNumber(String connectSourcePhoneNumber);

        /**
         * Sets the value of the AnswerMachineDetectionConfig property for this object.
         *
         * @param answerMachineDetectionConfig
         *        The new value for the AnswerMachineDetectionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig);

        /**
         * Sets the value of the AnswerMachineDetectionConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnswerMachineDetectionConfig.Builder}
         * avoiding the need to create one manually via {@link AnswerMachineDetectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnswerMachineDetectionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #answerMachineDetectionConfig(AnswerMachineDetectionConfig)}.
         * 
         * @param answerMachineDetectionConfig
         *        a consumer that will call methods on {@link AnswerMachineDetectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerMachineDetectionConfig(AnswerMachineDetectionConfig)
         */
        default Builder answerMachineDetectionConfig(Consumer<AnswerMachineDetectionConfig.Builder> answerMachineDetectionConfig) {
            return answerMachineDetectionConfig(AnswerMachineDetectionConfig.builder()
                    .applyMutation(answerMachineDetectionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectContactFlowId;

        private String connectSourcePhoneNumber;

        private AnswerMachineDetectionConfig answerMachineDetectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyOutboundConfig model) {
            connectContactFlowId(model.connectContactFlowId);
            connectSourcePhoneNumber(model.connectSourcePhoneNumber);
            answerMachineDetectionConfig(model.answerMachineDetectionConfig);
        }

        public final String getConnectContactFlowId() {
            return connectContactFlowId;
        }

        public final void setConnectContactFlowId(String connectContactFlowId) {
            this.connectContactFlowId = connectContactFlowId;
        }

        @Override
        public final Builder connectContactFlowId(String connectContactFlowId) {
            this.connectContactFlowId = connectContactFlowId;
            return this;
        }

        public final String getConnectSourcePhoneNumber() {
            return connectSourcePhoneNumber;
        }

        public final void setConnectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
        }

        @Override
        public final Builder connectSourcePhoneNumber(String connectSourcePhoneNumber) {
            this.connectSourcePhoneNumber = connectSourcePhoneNumber;
            return this;
        }

        public final AnswerMachineDetectionConfig.Builder getAnswerMachineDetectionConfig() {
            return answerMachineDetectionConfig != null ? answerMachineDetectionConfig.toBuilder() : null;
        }

        public final void setAnswerMachineDetectionConfig(AnswerMachineDetectionConfig.BuilderImpl answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig != null ? answerMachineDetectionConfig.build()
                    : null;
        }

        @Override
        public final Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig;
            return this;
        }

        @Override
        public TelephonyOutboundConfig build() {
            return new TelephonyOutboundConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
