/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Campaign Channel Subtype config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelSubtypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelSubtypeConfig.Builder, ChannelSubtypeConfig> {
    private static final SdkField<TelephonyChannelSubtypeConfig> TELEPHONY_FIELD = SdkField
            .<TelephonyChannelSubtypeConfig> builder(MarshallingType.SDK_POJO).memberName("telephony")
            .getter(getter(ChannelSubtypeConfig::telephony)).setter(setter(Builder::telephony))
            .constructor(TelephonyChannelSubtypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telephony").build()).build();

    private static final SdkField<SmsChannelSubtypeConfig> SMS_FIELD = SdkField
            .<SmsChannelSubtypeConfig> builder(MarshallingType.SDK_POJO).memberName("sms")
            .getter(getter(ChannelSubtypeConfig::sms)).setter(setter(Builder::sms)).constructor(SmsChannelSubtypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()).build();

    private static final SdkField<EmailChannelSubtypeConfig> EMAIL_FIELD = SdkField
            .<EmailChannelSubtypeConfig> builder(MarshallingType.SDK_POJO).memberName("email")
            .getter(getter(ChannelSubtypeConfig::email)).setter(setter(Builder::email))
            .constructor(EmailChannelSubtypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEPHONY_FIELD, SMS_FIELD,
            EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TelephonyChannelSubtypeConfig telephony;

    private final SmsChannelSubtypeConfig sms;

    private final EmailChannelSubtypeConfig email;

    private ChannelSubtypeConfig(BuilderImpl builder) {
        this.telephony = builder.telephony;
        this.sms = builder.sms;
        this.email = builder.email;
    }

    /**
     * Returns the value of the Telephony property for this object.
     * 
     * @return The value of the Telephony property for this object.
     */
    public final TelephonyChannelSubtypeConfig telephony() {
        return telephony;
    }

    /**
     * Returns the value of the Sms property for this object.
     * 
     * @return The value of the Sms property for this object.
     */
    public final SmsChannelSubtypeConfig sms() {
        return sms;
    }

    /**
     * Returns the value of the Email property for this object.
     * 
     * @return The value of the Email property for this object.
     */
    public final EmailChannelSubtypeConfig email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(telephony());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSubtypeConfig)) {
            return false;
        }
        ChannelSubtypeConfig other = (ChannelSubtypeConfig) obj;
        return Objects.equals(telephony(), other.telephony()) && Objects.equals(sms(), other.sms())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelSubtypeConfig").add("Telephony", telephony()).add("Sms", sms()).add("Email", email())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "telephony":
            return Optional.ofNullable(clazz.cast(telephony()));
        case "sms":
            return Optional.ofNullable(clazz.cast(sms()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("telephony", TELEPHONY_FIELD);
        map.put("sms", SMS_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelSubtypeConfig, T> g) {
        return obj -> g.apply((ChannelSubtypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelSubtypeConfig> {
        /**
         * Sets the value of the Telephony property for this object.
         *
         * @param telephony
         *        The new value for the Telephony property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephony(TelephonyChannelSubtypeConfig telephony);

        /**
         * Sets the value of the Telephony property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TelephonyChannelSubtypeConfig.Builder}
         * avoiding the need to create one manually via {@link TelephonyChannelSubtypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyChannelSubtypeConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #telephony(TelephonyChannelSubtypeConfig)}.
         * 
         * @param telephony
         *        a consumer that will call methods on {@link TelephonyChannelSubtypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephony(TelephonyChannelSubtypeConfig)
         */
        default Builder telephony(Consumer<TelephonyChannelSubtypeConfig.Builder> telephony) {
            return telephony(TelephonyChannelSubtypeConfig.builder().applyMutation(telephony).build());
        }

        /**
         * Sets the value of the Sms property for this object.
         *
         * @param sms
         *        The new value for the Sms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(SmsChannelSubtypeConfig sms);

        /**
         * Sets the value of the Sms property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SmsChannelSubtypeConfig.Builder} avoiding
         * the need to create one manually via {@link SmsChannelSubtypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsChannelSubtypeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #sms(SmsChannelSubtypeConfig)}.
         * 
         * @param sms
         *        a consumer that will call methods on {@link SmsChannelSubtypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(SmsChannelSubtypeConfig)
         */
        default Builder sms(Consumer<SmsChannelSubtypeConfig.Builder> sms) {
            return sms(SmsChannelSubtypeConfig.builder().applyMutation(sms).build());
        }

        /**
         * Sets the value of the Email property for this object.
         *
         * @param email
         *        The new value for the Email property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(EmailChannelSubtypeConfig email);

        /**
         * Sets the value of the Email property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EmailChannelSubtypeConfig.Builder}
         * avoiding the need to create one manually via {@link EmailChannelSubtypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailChannelSubtypeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #email(EmailChannelSubtypeConfig)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link EmailChannelSubtypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(EmailChannelSubtypeConfig)
         */
        default Builder email(Consumer<EmailChannelSubtypeConfig.Builder> email) {
            return email(EmailChannelSubtypeConfig.builder().applyMutation(email).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TelephonyChannelSubtypeConfig telephony;

        private SmsChannelSubtypeConfig sms;

        private EmailChannelSubtypeConfig email;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSubtypeConfig model) {
            telephony(model.telephony);
            sms(model.sms);
            email(model.email);
        }

        public final TelephonyChannelSubtypeConfig.Builder getTelephony() {
            return telephony != null ? telephony.toBuilder() : null;
        }

        public final void setTelephony(TelephonyChannelSubtypeConfig.BuilderImpl telephony) {
            this.telephony = telephony != null ? telephony.build() : null;
        }

        @Override
        public final Builder telephony(TelephonyChannelSubtypeConfig telephony) {
            this.telephony = telephony;
            return this;
        }

        public final SmsChannelSubtypeConfig.Builder getSms() {
            return sms != null ? sms.toBuilder() : null;
        }

        public final void setSms(SmsChannelSubtypeConfig.BuilderImpl sms) {
            this.sms = sms != null ? sms.build() : null;
        }

        @Override
        public final Builder sms(SmsChannelSubtypeConfig sms) {
            this.sms = sms;
            return this;
        }

        public final EmailChannelSubtypeConfig.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        public final void setEmail(EmailChannelSubtypeConfig.BuilderImpl email) {
            this.email = email != null ? email.build() : null;
        }

        @Override
        public final Builder email(EmailChannelSubtypeConfig email) {
            this.email = email;
            return this;
        }

        @Override
        public ChannelSubtypeConfig build() {
            return new ChannelSubtypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
