/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Campaign communication time config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommunicationTimeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CommunicationTimeConfig.Builder, CommunicationTimeConfig> {
    private static final SdkField<LocalTimeZoneConfig> LOCAL_TIME_ZONE_CONFIG_FIELD = SdkField
            .<LocalTimeZoneConfig> builder(MarshallingType.SDK_POJO).memberName("localTimeZoneConfig")
            .getter(getter(CommunicationTimeConfig::localTimeZoneConfig)).setter(setter(Builder::localTimeZoneConfig))
            .constructor(LocalTimeZoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localTimeZoneConfig").build())
            .build();

    private static final SdkField<TimeWindow> TELEPHONY_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("telephony").getter(getter(CommunicationTimeConfig::telephony)).setter(setter(Builder::telephony))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telephony").build()).build();

    private static final SdkField<TimeWindow> SMS_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("sms").getter(getter(CommunicationTimeConfig::sms)).setter(setter(Builder::sms))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()).build();

    private static final SdkField<TimeWindow> EMAIL_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("email").getter(getter(CommunicationTimeConfig::email)).setter(setter(Builder::email))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_TIME_ZONE_CONFIG_FIELD,
            TELEPHONY_FIELD, SMS_FIELD, EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LocalTimeZoneConfig localTimeZoneConfig;

    private final TimeWindow telephony;

    private final TimeWindow sms;

    private final TimeWindow email;

    private CommunicationTimeConfig(BuilderImpl builder) {
        this.localTimeZoneConfig = builder.localTimeZoneConfig;
        this.telephony = builder.telephony;
        this.sms = builder.sms;
        this.email = builder.email;
    }

    /**
     * Returns the value of the LocalTimeZoneConfig property for this object.
     * 
     * @return The value of the LocalTimeZoneConfig property for this object.
     */
    public final LocalTimeZoneConfig localTimeZoneConfig() {
        return localTimeZoneConfig;
    }

    /**
     * Returns the value of the Telephony property for this object.
     * 
     * @return The value of the Telephony property for this object.
     */
    public final TimeWindow telephony() {
        return telephony;
    }

    /**
     * Returns the value of the Sms property for this object.
     * 
     * @return The value of the Sms property for this object.
     */
    public final TimeWindow sms() {
        return sms;
    }

    /**
     * Returns the value of the Email property for this object.
     * 
     * @return The value of the Email property for this object.
     */
    public final TimeWindow email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localTimeZoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(telephony());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationTimeConfig)) {
            return false;
        }
        CommunicationTimeConfig other = (CommunicationTimeConfig) obj;
        return Objects.equals(localTimeZoneConfig(), other.localTimeZoneConfig())
                && Objects.equals(telephony(), other.telephony()) && Objects.equals(sms(), other.sms())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommunicationTimeConfig").add("LocalTimeZoneConfig", localTimeZoneConfig())
                .add("Telephony", telephony()).add("Sms", sms()).add("Email", email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localTimeZoneConfig":
            return Optional.ofNullable(clazz.cast(localTimeZoneConfig()));
        case "telephony":
            return Optional.ofNullable(clazz.cast(telephony()));
        case "sms":
            return Optional.ofNullable(clazz.cast(sms()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("localTimeZoneConfig", LOCAL_TIME_ZONE_CONFIG_FIELD);
        map.put("telephony", TELEPHONY_FIELD);
        map.put("sms", SMS_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommunicationTimeConfig, T> g) {
        return obj -> g.apply((CommunicationTimeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommunicationTimeConfig> {
        /**
         * Sets the value of the LocalTimeZoneConfig property for this object.
         *
         * @param localTimeZoneConfig
         *        The new value for the LocalTimeZoneConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localTimeZoneConfig(LocalTimeZoneConfig localTimeZoneConfig);

        /**
         * Sets the value of the LocalTimeZoneConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LocalTimeZoneConfig.Builder} avoiding the
         * need to create one manually via {@link LocalTimeZoneConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalTimeZoneConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #localTimeZoneConfig(LocalTimeZoneConfig)}.
         * 
         * @param localTimeZoneConfig
         *        a consumer that will call methods on {@link LocalTimeZoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localTimeZoneConfig(LocalTimeZoneConfig)
         */
        default Builder localTimeZoneConfig(Consumer<LocalTimeZoneConfig.Builder> localTimeZoneConfig) {
            return localTimeZoneConfig(LocalTimeZoneConfig.builder().applyMutation(localTimeZoneConfig).build());
        }

        /**
         * Sets the value of the Telephony property for this object.
         *
         * @param telephony
         *        The new value for the Telephony property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephony(TimeWindow telephony);

        /**
         * Sets the value of the Telephony property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeWindow.Builder} avoiding the need to
         * create one manually via {@link TimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #telephony(TimeWindow)}.
         * 
         * @param telephony
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephony(TimeWindow)
         */
        default Builder telephony(Consumer<TimeWindow.Builder> telephony) {
            return telephony(TimeWindow.builder().applyMutation(telephony).build());
        }

        /**
         * Sets the value of the Sms property for this object.
         *
         * @param sms
         *        The new value for the Sms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(TimeWindow sms);

        /**
         * Sets the value of the Sms property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeWindow.Builder} avoiding the need to
         * create one manually via {@link TimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #sms(TimeWindow)}.
         * 
         * @param sms
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(TimeWindow)
         */
        default Builder sms(Consumer<TimeWindow.Builder> sms) {
            return sms(TimeWindow.builder().applyMutation(sms).build());
        }

        /**
         * Sets the value of the Email property for this object.
         *
         * @param email
         *        The new value for the Email property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(TimeWindow email);

        /**
         * Sets the value of the Email property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeWindow.Builder} avoiding the need to
         * create one manually via {@link TimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #email(TimeWindow)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(TimeWindow)
         */
        default Builder email(Consumer<TimeWindow.Builder> email) {
            return email(TimeWindow.builder().applyMutation(email).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LocalTimeZoneConfig localTimeZoneConfig;

        private TimeWindow telephony;

        private TimeWindow sms;

        private TimeWindow email;

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationTimeConfig model) {
            localTimeZoneConfig(model.localTimeZoneConfig);
            telephony(model.telephony);
            sms(model.sms);
            email(model.email);
        }

        public final LocalTimeZoneConfig.Builder getLocalTimeZoneConfig() {
            return localTimeZoneConfig != null ? localTimeZoneConfig.toBuilder() : null;
        }

        public final void setLocalTimeZoneConfig(LocalTimeZoneConfig.BuilderImpl localTimeZoneConfig) {
            this.localTimeZoneConfig = localTimeZoneConfig != null ? localTimeZoneConfig.build() : null;
        }

        @Override
        public final Builder localTimeZoneConfig(LocalTimeZoneConfig localTimeZoneConfig) {
            this.localTimeZoneConfig = localTimeZoneConfig;
            return this;
        }

        public final TimeWindow.Builder getTelephony() {
            return telephony != null ? telephony.toBuilder() : null;
        }

        public final void setTelephony(TimeWindow.BuilderImpl telephony) {
            this.telephony = telephony != null ? telephony.build() : null;
        }

        @Override
        public final Builder telephony(TimeWindow telephony) {
            this.telephony = telephony;
            return this;
        }

        public final TimeWindow.Builder getSms() {
            return sms != null ? sms.toBuilder() : null;
        }

        public final void setSms(TimeWindow.BuilderImpl sms) {
            this.sms = sms != null ? sms.build() : null;
        }

        @Override
        public final Builder sms(TimeWindow sms) {
            this.sms = sms;
            return this;
        }

        public final TimeWindow.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        public final void setEmail(TimeWindow.BuilderImpl email) {
            this.email = email != null ? email.build() : null;
        }

        @Override
        public final Builder email(TimeWindow email) {
            this.email = email;
            return this;
        }

        @Override
        public CommunicationTimeConfig build() {
            return new CommunicationTimeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
