/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response for GetInstanceCommunicationLimits API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceCommunicationLimitsResponse extends ConnectCampaignsV2Response implements
        ToCopyableBuilder<GetInstanceCommunicationLimitsResponse.Builder, GetInstanceCommunicationLimitsResponse> {
    private static final SdkField<InstanceCommunicationLimitsConfig> COMMUNICATION_LIMITS_CONFIG_FIELD = SdkField
            .<InstanceCommunicationLimitsConfig> builder(MarshallingType.SDK_POJO).memberName("communicationLimitsConfig")
            .getter(getter(GetInstanceCommunicationLimitsResponse::communicationLimitsConfig))
            .setter(setter(Builder::communicationLimitsConfig)).constructor(InstanceCommunicationLimitsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationLimitsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMMUNICATION_LIMITS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InstanceCommunicationLimitsConfig communicationLimitsConfig;

    private GetInstanceCommunicationLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.communicationLimitsConfig = builder.communicationLimitsConfig;
    }

    /**
     * Returns the value of the CommunicationLimitsConfig property for this object.
     * 
     * @return The value of the CommunicationLimitsConfig property for this object.
     */
    public final InstanceCommunicationLimitsConfig communicationLimitsConfig() {
        return communicationLimitsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(communicationLimitsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceCommunicationLimitsResponse)) {
            return false;
        }
        GetInstanceCommunicationLimitsResponse other = (GetInstanceCommunicationLimitsResponse) obj;
        return Objects.equals(communicationLimitsConfig(), other.communicationLimitsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceCommunicationLimitsResponse")
                .add("CommunicationLimitsConfig", communicationLimitsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "communicationLimitsConfig":
            return Optional.ofNullable(clazz.cast(communicationLimitsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("communicationLimitsConfig", COMMUNICATION_LIMITS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceCommunicationLimitsResponse, T> g) {
        return obj -> g.apply((GetInstanceCommunicationLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInstanceCommunicationLimitsResponse> {
        /**
         * Sets the value of the CommunicationLimitsConfig property for this object.
         *
         * @param communicationLimitsConfig
         *        The new value for the CommunicationLimitsConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationLimitsConfig(InstanceCommunicationLimitsConfig communicationLimitsConfig);

        /**
         * Sets the value of the CommunicationLimitsConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link InstanceCommunicationLimitsConfig.Builder} avoiding the need to create one manually via
         * {@link InstanceCommunicationLimitsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceCommunicationLimitsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #communicationLimitsConfig(InstanceCommunicationLimitsConfig)}.
         * 
         * @param communicationLimitsConfig
         *        a consumer that will call methods on {@link InstanceCommunicationLimitsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationLimitsConfig(InstanceCommunicationLimitsConfig)
         */
        default Builder communicationLimitsConfig(Consumer<InstanceCommunicationLimitsConfig.Builder> communicationLimitsConfig) {
            return communicationLimitsConfig(InstanceCommunicationLimitsConfig.builder().applyMutation(communicationLimitsConfig)
                    .build());
        }
    }

    static final class BuilderImpl extends ConnectCampaignsV2Response.BuilderImpl implements Builder {
        private InstanceCommunicationLimitsConfig communicationLimitsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceCommunicationLimitsResponse model) {
            super(model);
            communicationLimitsConfig(model.communicationLimitsConfig);
        }

        public final InstanceCommunicationLimitsConfig.Builder getCommunicationLimitsConfig() {
            return communicationLimitsConfig != null ? communicationLimitsConfig.toBuilder() : null;
        }

        public final void setCommunicationLimitsConfig(InstanceCommunicationLimitsConfig.BuilderImpl communicationLimitsConfig) {
            this.communicationLimitsConfig = communicationLimitsConfig != null ? communicationLimitsConfig.build() : null;
        }

        @Override
        public final Builder communicationLimitsConfig(InstanceCommunicationLimitsConfig communicationLimitsConfig) {
            this.communicationLimitsConfig = communicationLimitsConfig;
            return this;
        }

        @Override
        public GetInstanceCommunicationLimitsResponse build() {
            return new GetInstanceCommunicationLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
