/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Preview config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreviewConfig implements SdkPojo, Serializable, ToCopyableBuilder<PreviewConfig.Builder, PreviewConfig> {
    private static final SdkField<Double> BANDWIDTH_ALLOCATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("bandwidthAllocation").getter(getter(PreviewConfig::bandwidthAllocation))
            .setter(setter(Builder::bandwidthAllocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthAllocation").build())
            .build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(PreviewConfig::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<List<String>> AGENT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("agentActions")
            .getter(getter(PreviewConfig::agentActionsAsStrings))
            .setter(setter(Builder::agentActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_ALLOCATION_FIELD,
            TIMEOUT_CONFIG_FIELD, AGENT_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double bandwidthAllocation;

    private final TimeoutConfig timeoutConfig;

    private final List<String> agentActions;

    private PreviewConfig(BuilderImpl builder) {
        this.bandwidthAllocation = builder.bandwidthAllocation;
        this.timeoutConfig = builder.timeoutConfig;
        this.agentActions = builder.agentActions;
    }

    /**
     * Returns the value of the BandwidthAllocation property for this object.
     * 
     * @return The value of the BandwidthAllocation property for this object.
     */
    public final Double bandwidthAllocation() {
        return bandwidthAllocation;
    }

    /**
     * Returns the value of the TimeoutConfig property for this object.
     * 
     * @return The value of the TimeoutConfig property for this object.
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * Returns the value of the AgentActions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentActions} method.
     * </p>
     * 
     * @return The value of the AgentActions property for this object.
     */
    public final List<AgentAction> agentActions() {
        return AgentActionsCopier.copyStringToEnum(agentActions);
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentActions() {
        return agentActions != null && !(agentActions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AgentActions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentActions} method.
     * </p>
     * 
     * @return The value of the AgentActions property for this object.
     */
    public final List<String> agentActionsAsStrings() {
        return agentActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthAllocation());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentActions() ? agentActionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewConfig)) {
            return false;
        }
        PreviewConfig other = (PreviewConfig) obj;
        return Objects.equals(bandwidthAllocation(), other.bandwidthAllocation())
                && Objects.equals(timeoutConfig(), other.timeoutConfig()) && hasAgentActions() == other.hasAgentActions()
                && Objects.equals(agentActionsAsStrings(), other.agentActionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreviewConfig").add("BandwidthAllocation", bandwidthAllocation())
                .add("TimeoutConfig", timeoutConfig()).add("AgentActions", hasAgentActions() ? agentActionsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bandwidthAllocation":
            return Optional.ofNullable(clazz.cast(bandwidthAllocation()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "agentActions":
            return Optional.ofNullable(clazz.cast(agentActionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bandwidthAllocation", BANDWIDTH_ALLOCATION_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        map.put("agentActions", AGENT_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewConfig, T> g) {
        return obj -> g.apply((PreviewConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreviewConfig> {
        /**
         * Sets the value of the BandwidthAllocation property for this object.
         *
         * @param bandwidthAllocation
         *        The new value for the BandwidthAllocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthAllocation(Double bandwidthAllocation);

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * @param timeoutConfig
         *        The new value for the TimeoutConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link TimeoutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * Sets the value of the AgentActions property for this object.
         *
         * @param agentActions
         *        The new value for the AgentActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentActionsWithStrings(Collection<String> agentActions);

        /**
         * Sets the value of the AgentActions property for this object.
         *
         * @param agentActions
         *        The new value for the AgentActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentActionsWithStrings(String... agentActions);

        /**
         * Sets the value of the AgentActions property for this object.
         *
         * @param agentActions
         *        The new value for the AgentActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentActions(Collection<AgentAction> agentActions);

        /**
         * Sets the value of the AgentActions property for this object.
         *
         * @param agentActions
         *        The new value for the AgentActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentActions(AgentAction... agentActions);
    }

    static final class BuilderImpl implements Builder {
        private Double bandwidthAllocation;

        private TimeoutConfig timeoutConfig;

        private List<String> agentActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewConfig model) {
            bandwidthAllocation(model.bandwidthAllocation);
            timeoutConfig(model.timeoutConfig);
            agentActionsWithStrings(model.agentActions);
        }

        public final Double getBandwidthAllocation() {
            return bandwidthAllocation;
        }

        public final void setBandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
        }

        @Override
        public final Builder bandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final Collection<String> getAgentActions() {
            if (agentActions instanceof SdkAutoConstructList) {
                return null;
            }
            return agentActions;
        }

        public final void setAgentActions(Collection<String> agentActions) {
            this.agentActions = AgentActionsCopier.copy(agentActions);
        }

        @Override
        public final Builder agentActionsWithStrings(Collection<String> agentActions) {
            this.agentActions = AgentActionsCopier.copy(agentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentActionsWithStrings(String... agentActions) {
            agentActionsWithStrings(Arrays.asList(agentActions));
            return this;
        }

        @Override
        public final Builder agentActions(Collection<AgentAction> agentActions) {
            this.agentActions = AgentActionsCopier.copyEnumToString(agentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentActions(AgentAction... agentActions) {
            agentActions(Arrays.asList(agentActions));
            return this;
        }

        @Override
        public PreviewConfig build() {
            return new PreviewConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
