/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for PutInstanceCommunicationLimits API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInstanceCommunicationLimitsRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<PutInstanceCommunicationLimitsRequest.Builder, PutInstanceCommunicationLimitsRequest> {
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectInstanceId").getter(getter(PutInstanceCommunicationLimitsRequest::connectInstanceId))
            .setter(setter(Builder::connectInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("connectInstanceId").build()).build();

    private static final SdkField<InstanceCommunicationLimitsConfig> COMMUNICATION_LIMITS_CONFIG_FIELD = SdkField
            .<InstanceCommunicationLimitsConfig> builder(MarshallingType.SDK_POJO).memberName("communicationLimitsConfig")
            .getter(getter(PutInstanceCommunicationLimitsRequest::communicationLimitsConfig))
            .setter(setter(Builder::communicationLimitsConfig)).constructor(InstanceCommunicationLimitsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationLimitsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_INSTANCE_ID_FIELD,
            COMMUNICATION_LIMITS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectInstanceId;

    private final InstanceCommunicationLimitsConfig communicationLimitsConfig;

    private PutInstanceCommunicationLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.connectInstanceId = builder.connectInstanceId;
        this.communicationLimitsConfig = builder.communicationLimitsConfig;
    }

    /**
     * Returns the value of the ConnectInstanceId property for this object.
     * 
     * @return The value of the ConnectInstanceId property for this object.
     */
    public final String connectInstanceId() {
        return connectInstanceId;
    }

    /**
     * Returns the value of the CommunicationLimitsConfig property for this object.
     * 
     * @return The value of the CommunicationLimitsConfig property for this object.
     */
    public final InstanceCommunicationLimitsConfig communicationLimitsConfig() {
        return communicationLimitsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(communicationLimitsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstanceCommunicationLimitsRequest)) {
            return false;
        }
        PutInstanceCommunicationLimitsRequest other = (PutInstanceCommunicationLimitsRequest) obj;
        return Objects.equals(connectInstanceId(), other.connectInstanceId())
                && Objects.equals(communicationLimitsConfig(), other.communicationLimitsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutInstanceCommunicationLimitsRequest").add("ConnectInstanceId", connectInstanceId())
                .add("CommunicationLimitsConfig", communicationLimitsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectInstanceId":
            return Optional.ofNullable(clazz.cast(connectInstanceId()));
        case "communicationLimitsConfig":
            return Optional.ofNullable(clazz.cast(communicationLimitsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("communicationLimitsConfig", COMMUNICATION_LIMITS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInstanceCommunicationLimitsRequest, T> g) {
        return obj -> g.apply((PutInstanceCommunicationLimitsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutInstanceCommunicationLimitsRequest> {
        /**
         * Sets the value of the ConnectInstanceId property for this object.
         *
         * @param connectInstanceId
         *        The new value for the ConnectInstanceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceId(String connectInstanceId);

        /**
         * Sets the value of the CommunicationLimitsConfig property for this object.
         *
         * @param communicationLimitsConfig
         *        The new value for the CommunicationLimitsConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationLimitsConfig(InstanceCommunicationLimitsConfig communicationLimitsConfig);

        /**
         * Sets the value of the CommunicationLimitsConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link InstanceCommunicationLimitsConfig.Builder} avoiding the need to create one manually via
         * {@link InstanceCommunicationLimitsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceCommunicationLimitsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #communicationLimitsConfig(InstanceCommunicationLimitsConfig)}.
         * 
         * @param communicationLimitsConfig
         *        a consumer that will call methods on {@link InstanceCommunicationLimitsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationLimitsConfig(InstanceCommunicationLimitsConfig)
         */
        default Builder communicationLimitsConfig(Consumer<InstanceCommunicationLimitsConfig.Builder> communicationLimitsConfig) {
            return communicationLimitsConfig(InstanceCommunicationLimitsConfig.builder().applyMutation(communicationLimitsConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String connectInstanceId;

        private InstanceCommunicationLimitsConfig communicationLimitsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstanceCommunicationLimitsRequest model) {
            super(model);
            connectInstanceId(model.connectInstanceId);
            communicationLimitsConfig(model.communicationLimitsConfig);
        }

        public final String getConnectInstanceId() {
            return connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final InstanceCommunicationLimitsConfig.Builder getCommunicationLimitsConfig() {
            return communicationLimitsConfig != null ? communicationLimitsConfig.toBuilder() : null;
        }

        public final void setCommunicationLimitsConfig(InstanceCommunicationLimitsConfig.BuilderImpl communicationLimitsConfig) {
            this.communicationLimitsConfig = communicationLimitsConfig != null ? communicationLimitsConfig.build() : null;
        }

        @Override
        public final Builder communicationLimitsConfig(InstanceCommunicationLimitsConfig communicationLimitsConfig) {
            this.communicationLimitsConfig = communicationLimitsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInstanceCommunicationLimitsRequest build() {
            return new PutInstanceCommunicationLimitsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
