/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Telephony Outbound Mode
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelephonyOutboundMode implements SdkPojo, Serializable,
        ToCopyableBuilder<TelephonyOutboundMode.Builder, TelephonyOutboundMode> {
    private static final SdkField<ProgressiveConfig> PROGRESSIVE_FIELD = SdkField
            .<ProgressiveConfig> builder(MarshallingType.SDK_POJO).memberName("progressive")
            .getter(getter(TelephonyOutboundMode::progressive)).setter(setter(Builder::progressive))
            .constructor(ProgressiveConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressive").build()).build();

    private static final SdkField<PredictiveConfig> PREDICTIVE_FIELD = SdkField
            .<PredictiveConfig> builder(MarshallingType.SDK_POJO).memberName("predictive")
            .getter(getter(TelephonyOutboundMode::predictive)).setter(setter(Builder::predictive))
            .constructor(PredictiveConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictive").build()).build();

    private static final SdkField<AgentlessConfig> AGENTLESS_FIELD = SdkField.<AgentlessConfig> builder(MarshallingType.SDK_POJO)
            .memberName("agentless").getter(getter(TelephonyOutboundMode::agentless)).setter(setter(Builder::agentless))
            .constructor(AgentlessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentless").build()).build();

    private static final SdkField<PreviewConfig> PREVIEW_FIELD = SdkField.<PreviewConfig> builder(MarshallingType.SDK_POJO)
            .memberName("preview").getter(getter(TelephonyOutboundMode::preview)).setter(setter(Builder::preview))
            .constructor(PreviewConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESSIVE_FIELD,
            PREDICTIVE_FIELD, AGENTLESS_FIELD, PREVIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProgressiveConfig progressive;

    private final PredictiveConfig predictive;

    private final AgentlessConfig agentless;

    private final PreviewConfig preview;

    private final Type type;

    private TelephonyOutboundMode(BuilderImpl builder) {
        this.progressive = builder.progressive;
        this.predictive = builder.predictive;
        this.agentless = builder.agentless;
        this.preview = builder.preview;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Progressive property for this object.
     * 
     * @return The value of the Progressive property for this object.
     */
    public final ProgressiveConfig progressive() {
        return progressive;
    }

    /**
     * Returns the value of the Predictive property for this object.
     * 
     * @return The value of the Predictive property for this object.
     */
    public final PredictiveConfig predictive() {
        return predictive;
    }

    /**
     * Returns the value of the Agentless property for this object.
     * 
     * @return The value of the Agentless property for this object.
     */
    public final AgentlessConfig agentless() {
        return agentless;
    }

    /**
     * Returns the value of the Preview property for this object.
     * 
     * @return The value of the Preview property for this object.
     */
    public final PreviewConfig preview() {
        return preview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressive());
        hashCode = 31 * hashCode + Objects.hashCode(predictive());
        hashCode = 31 * hashCode + Objects.hashCode(agentless());
        hashCode = 31 * hashCode + Objects.hashCode(preview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonyOutboundMode)) {
            return false;
        }
        TelephonyOutboundMode other = (TelephonyOutboundMode) obj;
        return Objects.equals(progressive(), other.progressive()) && Objects.equals(predictive(), other.predictive())
                && Objects.equals(agentless(), other.agentless()) && Objects.equals(preview(), other.preview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelephonyOutboundMode").add("Progressive", progressive()).add("Predictive", predictive())
                .add("Agentless", agentless()).add("Preview", preview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "progressive":
            return Optional.ofNullable(clazz.cast(progressive()));
        case "predictive":
            return Optional.ofNullable(clazz.cast(predictive()));
        case "agentless":
            return Optional.ofNullable(clazz.cast(agentless()));
        case "preview":
            return Optional.ofNullable(clazz.cast(preview()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #progressive()} initialized to the given value.
     *
     * Sets the value of the Progressive property for this object.
     *
     * @param progressive
     *        The new value for the Progressive property for this object.
     */
    public static TelephonyOutboundMode fromProgressive(ProgressiveConfig progressive) {
        return builder().progressive(progressive).build();
    }

    /**
     * Create an instance of this class with {@link #progressive()} initialized to the given value.
     *
     * Sets the value of the Progressive property for this object.
     *
     * @param progressive
     *        The new value for the Progressive property for this object.
     */
    public static TelephonyOutboundMode fromProgressive(Consumer<ProgressiveConfig.Builder> progressive) {
        ProgressiveConfig.Builder builder = ProgressiveConfig.builder();
        progressive.accept(builder);
        return fromProgressive(builder.build());
    }

    /**
     * Create an instance of this class with {@link #predictive()} initialized to the given value.
     *
     * Sets the value of the Predictive property for this object.
     *
     * @param predictive
     *        The new value for the Predictive property for this object.
     */
    public static TelephonyOutboundMode fromPredictive(PredictiveConfig predictive) {
        return builder().predictive(predictive).build();
    }

    /**
     * Create an instance of this class with {@link #predictive()} initialized to the given value.
     *
     * Sets the value of the Predictive property for this object.
     *
     * @param predictive
     *        The new value for the Predictive property for this object.
     */
    public static TelephonyOutboundMode fromPredictive(Consumer<PredictiveConfig.Builder> predictive) {
        PredictiveConfig.Builder builder = PredictiveConfig.builder();
        predictive.accept(builder);
        return fromPredictive(builder.build());
    }

    /**
     * Create an instance of this class with {@link #agentless()} initialized to the given value.
     *
     * Sets the value of the Agentless property for this object.
     *
     * @param agentless
     *        The new value for the Agentless property for this object.
     */
    public static TelephonyOutboundMode fromAgentless(AgentlessConfig agentless) {
        return builder().agentless(agentless).build();
    }

    /**
     * Create an instance of this class with {@link #agentless()} initialized to the given value.
     *
     * Sets the value of the Agentless property for this object.
     *
     * @param agentless
     *        The new value for the Agentless property for this object.
     */
    public static TelephonyOutboundMode fromAgentless(Consumer<AgentlessConfig.Builder> agentless) {
        AgentlessConfig.Builder builder = AgentlessConfig.builder();
        agentless.accept(builder);
        return fromAgentless(builder.build());
    }

    /**
     * Create an instance of this class with {@link #preview()} initialized to the given value.
     *
     * Sets the value of the Preview property for this object.
     *
     * @param preview
     *        The new value for the Preview property for this object.
     */
    public static TelephonyOutboundMode fromPreview(PreviewConfig preview) {
        return builder().preview(preview).build();
    }

    /**
     * Create an instance of this class with {@link #preview()} initialized to the given value.
     *
     * Sets the value of the Preview property for this object.
     *
     * @param preview
     *        The new value for the Preview property for this object.
     */
    public static TelephonyOutboundMode fromPreview(Consumer<PreviewConfig.Builder> preview) {
        PreviewConfig.Builder builder = PreviewConfig.builder();
        preview.accept(builder);
        return fromPreview(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("progressive", PROGRESSIVE_FIELD);
        map.put("predictive", PREDICTIVE_FIELD);
        map.put("agentless", AGENTLESS_FIELD);
        map.put("preview", PREVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonyOutboundMode, T> g) {
        return obj -> g.apply((TelephonyOutboundMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelephonyOutboundMode> {
        /**
         * Sets the value of the Progressive property for this object.
         *
         * @param progressive
         *        The new value for the Progressive property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressive(ProgressiveConfig progressive);

        /**
         * Sets the value of the Progressive property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProgressiveConfig.Builder} avoiding the
         * need to create one manually via {@link ProgressiveConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgressiveConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #progressive(ProgressiveConfig)}.
         * 
         * @param progressive
         *        a consumer that will call methods on {@link ProgressiveConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressive(ProgressiveConfig)
         */
        default Builder progressive(Consumer<ProgressiveConfig.Builder> progressive) {
            return progressive(ProgressiveConfig.builder().applyMutation(progressive).build());
        }

        /**
         * Sets the value of the Predictive property for this object.
         *
         * @param predictive
         *        The new value for the Predictive property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictive(PredictiveConfig predictive);

        /**
         * Sets the value of the Predictive property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PredictiveConfig.Builder} avoiding the
         * need to create one manually via {@link PredictiveConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #predictive(PredictiveConfig)}.
         * 
         * @param predictive
         *        a consumer that will call methods on {@link PredictiveConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictive(PredictiveConfig)
         */
        default Builder predictive(Consumer<PredictiveConfig.Builder> predictive) {
            return predictive(PredictiveConfig.builder().applyMutation(predictive).build());
        }

        /**
         * Sets the value of the Agentless property for this object.
         *
         * @param agentless
         *        The new value for the Agentless property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentless(AgentlessConfig agentless);

        /**
         * Sets the value of the Agentless property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AgentlessConfig.Builder} avoiding the
         * need to create one manually via {@link AgentlessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentlessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #agentless(AgentlessConfig)}.
         * 
         * @param agentless
         *        a consumer that will call methods on {@link AgentlessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentless(AgentlessConfig)
         */
        default Builder agentless(Consumer<AgentlessConfig.Builder> agentless) {
            return agentless(AgentlessConfig.builder().applyMutation(agentless).build());
        }

        /**
         * Sets the value of the Preview property for this object.
         *
         * @param preview
         *        The new value for the Preview property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preview(PreviewConfig preview);

        /**
         * Sets the value of the Preview property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PreviewConfig.Builder} avoiding the need
         * to create one manually via {@link PreviewConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreviewConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #preview(PreviewConfig)}.
         * 
         * @param preview
         *        a consumer that will call methods on {@link PreviewConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preview(PreviewConfig)
         */
        default Builder preview(Consumer<PreviewConfig.Builder> preview) {
            return preview(PreviewConfig.builder().applyMutation(preview).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProgressiveConfig progressive;

        private PredictiveConfig predictive;

        private AgentlessConfig agentless;

        private PreviewConfig preview;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonyOutboundMode model) {
            progressive(model.progressive);
            predictive(model.predictive);
            agentless(model.agentless);
            preview(model.preview);
        }

        public final ProgressiveConfig.Builder getProgressive() {
            return progressive != null ? progressive.toBuilder() : null;
        }

        public final void setProgressive(ProgressiveConfig.BuilderImpl progressive) {
            Object oldValue = this.progressive;
            this.progressive = progressive != null ? progressive.build() : null;
            handleUnionValueChange(Type.PROGRESSIVE, oldValue, this.progressive);
        }

        @Override
        public final Builder progressive(ProgressiveConfig progressive) {
            Object oldValue = this.progressive;
            this.progressive = progressive;
            handleUnionValueChange(Type.PROGRESSIVE, oldValue, this.progressive);
            return this;
        }

        public final PredictiveConfig.Builder getPredictive() {
            return predictive != null ? predictive.toBuilder() : null;
        }

        public final void setPredictive(PredictiveConfig.BuilderImpl predictive) {
            Object oldValue = this.predictive;
            this.predictive = predictive != null ? predictive.build() : null;
            handleUnionValueChange(Type.PREDICTIVE, oldValue, this.predictive);
        }

        @Override
        public final Builder predictive(PredictiveConfig predictive) {
            Object oldValue = this.predictive;
            this.predictive = predictive;
            handleUnionValueChange(Type.PREDICTIVE, oldValue, this.predictive);
            return this;
        }

        public final AgentlessConfig.Builder getAgentless() {
            return agentless != null ? agentless.toBuilder() : null;
        }

        public final void setAgentless(AgentlessConfig.BuilderImpl agentless) {
            Object oldValue = this.agentless;
            this.agentless = agentless != null ? agentless.build() : null;
            handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
        }

        @Override
        public final Builder agentless(AgentlessConfig agentless) {
            Object oldValue = this.agentless;
            this.agentless = agentless;
            handleUnionValueChange(Type.AGENTLESS, oldValue, this.agentless);
            return this;
        }

        public final PreviewConfig.Builder getPreview() {
            return preview != null ? preview.toBuilder() : null;
        }

        public final void setPreview(PreviewConfig.BuilderImpl preview) {
            Object oldValue = this.preview;
            this.preview = preview != null ? preview.build() : null;
            handleUnionValueChange(Type.PREVIEW, oldValue, this.preview);
        }

        @Override
        public final Builder preview(PreviewConfig preview) {
            Object oldValue = this.preview;
            this.preview = preview;
            handleUnionValueChange(Type.PREVIEW, oldValue, this.preview);
            return this;
        }

        @Override
        public TelephonyOutboundMode build() {
            return new TelephonyOutboundMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TelephonyOutboundMode#type()
     */
    public enum Type {
        PROGRESSIVE,

        PREDICTIVE,

        AGENTLESS,

        PREVIEW,

        UNKNOWN_TO_SDK_VERSION
    }
}
