/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for UpdateCampaignFlowAssociation API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignFlowAssociationRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<UpdateCampaignFlowAssociationRequest.Builder, UpdateCampaignFlowAssociationRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateCampaignFlowAssociationRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> CONNECT_CAMPAIGN_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectCampaignFlowArn").getter(getter(UpdateCampaignFlowAssociationRequest::connectCampaignFlowArn))
            .setter(setter(Builder::connectCampaignFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCampaignFlowArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CONNECT_CAMPAIGN_FLOW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String connectCampaignFlowArn;

    private UpdateCampaignFlowAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the ConnectCampaignFlowArn property for this object.
     * 
     * @return The value of the ConnectCampaignFlowArn property for this object.
     */
    public final String connectCampaignFlowArn() {
        return connectCampaignFlowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(connectCampaignFlowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignFlowAssociationRequest)) {
            return false;
        }
        UpdateCampaignFlowAssociationRequest other = (UpdateCampaignFlowAssociationRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(connectCampaignFlowArn(), other.connectCampaignFlowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignFlowAssociationRequest").add("Id", id())
                .add("ConnectCampaignFlowArn", connectCampaignFlowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "connectCampaignFlowArn":
            return Optional.ofNullable(clazz.cast(connectCampaignFlowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("connectCampaignFlowArn", CONNECT_CAMPAIGN_FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignFlowAssociationRequest, T> g) {
        return obj -> g.apply((UpdateCampaignFlowAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCampaignFlowAssociationRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ConnectCampaignFlowArn property for this object.
         *
         * @param connectCampaignFlowArn
         *        The new value for the ConnectCampaignFlowArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCampaignFlowArn(String connectCampaignFlowArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private String connectCampaignFlowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignFlowAssociationRequest model) {
            super(model);
            id(model.id);
            connectCampaignFlowArn(model.connectCampaignFlowArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getConnectCampaignFlowArn() {
            return connectCampaignFlowArn;
        }

        public final void setConnectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
        }

        @Override
        public final Builder connectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignFlowAssociationRequest build() {
            return new UpdateCampaignFlowAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
