/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request for UpdateCampaignSchedule API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignScheduleRequest extends ConnectCampaignsV2Request implements
        ToCopyableBuilder<UpdateCampaignScheduleRequest.Builder, UpdateCampaignScheduleRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateCampaignScheduleRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(UpdateCampaignScheduleRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final Schedule schedule;

    private UpdateCampaignScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.schedule = builder.schedule;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Schedule property for this object.
     * 
     * @return The value of the Schedule property for this object.
     */
    public final Schedule schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignScheduleRequest)) {
            return false;
        }
        UpdateCampaignScheduleRequest other = (UpdateCampaignScheduleRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignScheduleRequest").add("Id", id()).add("Schedule", schedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignScheduleRequest, T> g) {
        return obj -> g.apply((UpdateCampaignScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCampaignsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCampaignScheduleRequest> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * @param schedule
         *        The new value for the Schedule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsV2Request.BuilderImpl implements Builder {
        private String id;

        private Schedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignScheduleRequest model) {
            super(model);
            id(model.id);
            schedule(model.schedule);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignScheduleRequest build() {
            return new UpdateCampaignScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
