/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFieldOptionsResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<ListFieldOptionsResponse.Builder, ListFieldOptionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFieldOptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<FieldOption>> OPTIONS_FIELD = SdkField
            .<List<FieldOption>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(ListFieldOptionsResponse::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            OPTIONS_FIELD));

    private final String nextToken;

    private final List<FieldOption> options;

    private ListFieldOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.options = builder.options;
    }

    /**
     * <p>
     * The token for the next set of results. This is null if there are no more results to return.
     * </p>
     * 
     * @return The token for the next set of results. This is null if there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>FieldOption</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return A list of <code>FieldOption</code> objects.
     */
    public final List<FieldOption> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFieldOptionsResponse)) {
            return false;
        }
        ListFieldOptionsResponse other = (ListFieldOptionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFieldOptionsResponse").add("NextToken", nextToken())
                .add("Options", hasOptions() ? options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFieldOptionsResponse, T> g) {
        return obj -> g.apply((ListFieldOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFieldOptionsResponse> {
        /**
         * <p>
         * The token for the next set of results. This is null if there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. This is null if there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <code>FieldOption</code> objects.
         * </p>
         * 
         * @param options
         *        A list of <code>FieldOption</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<FieldOption> options);

        /**
         * <p>
         * A list of <code>FieldOption</code> objects.
         * </p>
         * 
         * @param options
         *        A list of <code>FieldOption</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(FieldOption... options);

        /**
         * <p>
         * A list of <code>FieldOption</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.FieldOption.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connectcases.model.FieldOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.FieldOption.Builder#build()} is called immediately
         * and its result is passed to {@link #options(List<FieldOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.FieldOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<FieldOption>)
         */
        Builder options(Consumer<FieldOption.Builder>... options);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FieldOption> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFieldOptionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            options(model.options);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FieldOption.Builder> getOptions() {
            List<FieldOption.Builder> result = FieldOptionsListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<FieldOption.BuilderImpl> options) {
            this.options = FieldOptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<FieldOption> options) {
            this.options = FieldOptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(FieldOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<FieldOption.Builder>... options) {
            options(Stream.of(options).map(c -> FieldOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFieldOptionsResponse build() {
            return new ListFieldOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
