/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<UpdateTemplateRequest.Builder, UpdateTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateTemplateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(UpdateTemplateRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<LayoutConfiguration> LAYOUT_CONFIGURATION_FIELD = SdkField
            .<LayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("layoutConfiguration")
            .getter(getter(UpdateTemplateRequest::layoutConfiguration)).setter(setter(Builder::layoutConfiguration))
            .constructor(LayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<RequiredField>> REQUIRED_FIELDS_FIELD = SdkField
            .<List<RequiredField>> builder(MarshallingType.LIST)
            .memberName("requiredFields")
            .getter(getter(UpdateTemplateRequest::requiredFields))
            .setter(setter(Builder::requiredFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequiredField> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequiredField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(UpdateTemplateRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_ID_FIELD, LAYOUT_CONFIGURATION_FIELD, NAME_FIELD, REQUIRED_FIELDS_FIELD, TEMPLATE_ID_FIELD));

    private final String description;

    private final String domainId;

    private final LayoutConfiguration layoutConfiguration;

    private final String name;

    private final List<RequiredField> requiredFields;

    private final String templateId;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.layoutConfiguration = builder.layoutConfiguration;
        this.name = builder.name;
        this.requiredFields = builder.requiredFields;
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * A brief description of the template.
     * </p>
     * 
     * @return A brief description of the template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Configuration of layouts associated to the template.
     * </p>
     * 
     * @return Configuration of layouts associated to the template.
     */
    public final LayoutConfiguration layoutConfiguration() {
        return layoutConfiguration;
    }

    /**
     * <p>
     * The name of the template. It must be unique per domain.
     * </p>
     * 
     * @return The name of the template. It must be unique per domain.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequiredFields() {
        return requiredFields != null && !(requiredFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields that must contain a value for a case to be successfully created with this template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredFields} method.
     * </p>
     * 
     * @return A list of fields that must contain a value for a case to be successfully created with this template.
     */
    public final List<RequiredField> requiredFields() {
        return requiredFields;
    }

    /**
     * <p>
     * A unique identifier for the template.
     * </p>
     * 
     * @return A unique identifier for the template.
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(layoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredFields() ? requiredFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(layoutConfiguration(), other.layoutConfiguration()) && Objects.equals(name(), other.name())
                && hasRequiredFields() == other.hasRequiredFields() && Objects.equals(requiredFields(), other.requiredFields())
                && Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateRequest").add("Description", description()).add("DomainId", domainId())
                .add("LayoutConfiguration", layoutConfiguration()).add("Name", name())
                .add("RequiredFields", hasRequiredFields() ? requiredFields() : null).add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "layoutConfiguration":
            return Optional.ofNullable(clazz.cast(layoutConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "requiredFields":
            return Optional.ofNullable(clazz.cast(requiredFields()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateRequest> {
        /**
         * <p>
         * A brief description of the template.
         * </p>
         * 
         * @param description
         *        A brief description of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Configuration of layouts associated to the template.
         * </p>
         * 
         * @param layoutConfiguration
         *        Configuration of layouts associated to the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutConfiguration(LayoutConfiguration layoutConfiguration);

        /**
         * <p>
         * Configuration of layouts associated to the template.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutConfiguration.Builder} avoiding the
         * need to create one manually via {@link LayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #layoutConfiguration(LayoutConfiguration)}.
         * 
         * @param layoutConfiguration
         *        a consumer that will call methods on {@link LayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layoutConfiguration(LayoutConfiguration)
         */
        default Builder layoutConfiguration(Consumer<LayoutConfiguration.Builder> layoutConfiguration) {
            return layoutConfiguration(LayoutConfiguration.builder().applyMutation(layoutConfiguration).build());
        }

        /**
         * <p>
         * The name of the template. It must be unique per domain.
         * </p>
         * 
         * @param name
         *        The name of the template. It must be unique per domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of fields that must contain a value for a case to be successfully created with this template.
         * </p>
         * 
         * @param requiredFields
         *        A list of fields that must contain a value for a case to be successfully created with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFields(Collection<RequiredField> requiredFields);

        /**
         * <p>
         * A list of fields that must contain a value for a case to be successfully created with this template.
         * </p>
         * 
         * @param requiredFields
         *        A list of fields that must contain a value for a case to be successfully created with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFields(RequiredField... requiredFields);

        /**
         * <p>
         * A list of fields that must contain a value for a case to be successfully created with this template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.RequiredField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connectcases.model.RequiredField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.RequiredField.Builder#build()} is called
         * immediately and its result is passed to {@link #requiredFields(List<RequiredField>)}.
         * 
         * @param requiredFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.RequiredField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requiredFields(java.util.Collection<RequiredField>)
         */
        Builder requiredFields(Consumer<RequiredField.Builder>... requiredFields);

        /**
         * <p>
         * A unique identifier for the template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String description;

        private String domainId;

        private LayoutConfiguration layoutConfiguration;

        private String name;

        private List<RequiredField> requiredFields = DefaultSdkAutoConstructList.getInstance();

        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            description(model.description);
            domainId(model.domainId);
            layoutConfiguration(model.layoutConfiguration);
            name(model.name);
            requiredFields(model.requiredFields);
            templateId(model.templateId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final LayoutConfiguration.Builder getLayoutConfiguration() {
            return layoutConfiguration != null ? layoutConfiguration.toBuilder() : null;
        }

        public final void setLayoutConfiguration(LayoutConfiguration.BuilderImpl layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration != null ? layoutConfiguration.build() : null;
        }

        @Override
        public final Builder layoutConfiguration(LayoutConfiguration layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RequiredField.Builder> getRequiredFields() {
            List<RequiredField.Builder> result = RequiredFieldListCopier.copyToBuilder(this.requiredFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredFields(Collection<RequiredField.BuilderImpl> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copyFromBuilder(requiredFields);
        }

        @Override
        public final Builder requiredFields(Collection<RequiredField> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copy(requiredFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(RequiredField... requiredFields) {
            requiredFields(Arrays.asList(requiredFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(Consumer<RequiredField.Builder>... requiredFields) {
            requiredFields(Stream.of(requiredFields).map(c -> RequiredField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
