/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCaseAuditEventsResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<GetCaseAuditEventsResponse.Builder, GetCaseAuditEventsResponse> {
    private static final SdkField<List<AuditEvent>> AUDIT_EVENTS_FIELD = SdkField
            .<List<AuditEvent>> builder(MarshallingType.LIST)
            .memberName("auditEvents")
            .getter(getter(GetCaseAuditEventsResponse::auditEvents))
            .setter(setter(Builder::auditEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetCaseAuditEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuditEvent> auditEvents;

    private final String nextToken;

    private GetCaseAuditEventsResponse(BuilderImpl builder) {
        super(builder);
        this.auditEvents = builder.auditEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditEvents() {
        return auditEvents != null && !(auditEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of case audits where each represents a particular edit of the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditEvents} method.
     * </p>
     * 
     * @return A list of case audits where each represents a particular edit of the case.
     */
    public final List<AuditEvent> auditEvents() {
        return auditEvents;
    }

    /**
     * <p>
     * The token for the next set of results. This is null if there are no more results to return.
     * </p>
     * 
     * @return The token for the next set of results. This is null if there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditEvents() ? auditEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseAuditEventsResponse)) {
            return false;
        }
        GetCaseAuditEventsResponse other = (GetCaseAuditEventsResponse) obj;
        return hasAuditEvents() == other.hasAuditEvents() && Objects.equals(auditEvents(), other.auditEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCaseAuditEventsResponse").add("AuditEvents", hasAuditEvents() ? auditEvents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auditEvents":
            return Optional.ofNullable(clazz.cast(auditEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCaseAuditEventsResponse, T> g) {
        return obj -> g.apply((GetCaseAuditEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCaseAuditEventsResponse> {
        /**
         * <p>
         * A list of case audits where each represents a particular edit of the case.
         * </p>
         * 
         * @param auditEvents
         *        A list of case audits where each represents a particular edit of the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditEvents(Collection<AuditEvent> auditEvents);

        /**
         * <p>
         * A list of case audits where each represents a particular edit of the case.
         * </p>
         * 
         * @param auditEvents
         *        A list of case audits where each represents a particular edit of the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditEvents(AuditEvent... auditEvents);

        /**
         * <p>
         * A list of case audits where each represents a particular edit of the case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.AuditEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.AuditEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.AuditEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #auditEvents(List<AuditEvent>)}.
         * 
         * @param auditEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.AuditEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditEvents(java.util.Collection<AuditEvent>)
         */
        Builder auditEvents(Consumer<AuditEvent.Builder>... auditEvents);

        /**
         * <p>
         * The token for the next set of results. This is null if there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. This is null if there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private List<AuditEvent> auditEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseAuditEventsResponse model) {
            super(model);
            auditEvents(model.auditEvents);
            nextToken(model.nextToken);
        }

        public final List<AuditEvent.Builder> getAuditEvents() {
            List<AuditEvent.Builder> result = GetCaseAuditEventsResponseAuditEventsListCopier.copyToBuilder(this.auditEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditEvents(Collection<AuditEvent.BuilderImpl> auditEvents) {
            this.auditEvents = GetCaseAuditEventsResponseAuditEventsListCopier.copyFromBuilder(auditEvents);
        }

        @Override
        public final Builder auditEvents(Collection<AuditEvent> auditEvents) {
            this.auditEvents = GetCaseAuditEventsResponseAuditEventsListCopier.copy(auditEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(AuditEvent... auditEvents) {
            auditEvents(Arrays.asList(auditEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(Consumer<AuditEvent.Builder>... auditEvents) {
            auditEvents(Stream.of(auditEvents).map(c -> AuditEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCaseAuditEventsResponse build() {
            return new GetCaseAuditEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
