/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.EventIncludedData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventBridgeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventBridgeConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(EventBridgeConfiguration.getter(EventBridgeConfiguration::enabled)).setter(EventBridgeConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<EventIncludedData> INCLUDED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includedData").getter(EventBridgeConfiguration.getter(EventBridgeConfiguration::includedData)).setter(EventBridgeConfiguration.setter(Builder::includedData)).constructor(EventIncludedData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INCLUDED_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final EventIncludedData includedData;

    private EventBridgeConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.includedData = builder.includedData;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final EventIncludedData includedData() {
        return this.includedData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventBridgeConfiguration)) {
            return false;
        }
        EventBridgeConfiguration other = (EventBridgeConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.includedData(), other.includedData());
    }

    public final String toString() {
        return ToString.builder((String)"EventBridgeConfiguration").add("Enabled", (Object)this.enabled()).add("IncludedData", (Object)this.includedData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "includedData": {
                return Optional.ofNullable(clazz.cast(this.includedData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventBridgeConfiguration, T> g) {
        return obj -> g.apply((EventBridgeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private EventIncludedData includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(EventBridgeConfiguration model) {
            this.enabled(model.enabled);
            this.includedData(model.includedData);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final EventIncludedData.Builder getIncludedData() {
            return this.includedData != null ? this.includedData.toBuilder() : null;
        }

        public final void setIncludedData(EventIncludedData.BuilderImpl includedData) {
            this.includedData = includedData != null ? includedData.build() : null;
        }

        @Override
        public final Builder includedData(EventIncludedData includedData) {
            this.includedData = includedData;
            return this;
        }

        public EventBridgeConfiguration build() {
            return new EventBridgeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventBridgeConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder includedData(EventIncludedData var1);

        default public Builder includedData(Consumer<EventIncludedData.Builder> includedData) {
            return this.includedData((EventIncludedData)((EventIncludedData.Builder)EventIncludedData.builder().applyMutation(includedData)).build());
        }
    }
}

