/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse;

public class ListLayoutsPublisher
implements SdkPublisher<ListLayoutsResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListLayoutsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLayoutsPublisher(ConnectCasesAsyncClient client, ListLayoutsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLayoutsPublisher(ConnectCasesAsyncClient client, ListLayoutsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLayoutsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLayoutsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLayoutsResponseFetcher
    implements AsyncPageFetcher<ListLayoutsResponse> {
        private ListLayoutsResponseFetcher() {
        }

        public boolean hasNextPage(ListLayoutsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLayoutsResponse> nextPage(ListLayoutsResponse previousPage) {
            if (previousPage == null) {
                return ListLayoutsPublisher.this.client.listLayouts(ListLayoutsPublisher.this.firstRequest);
            }
            return ListLayoutsPublisher.this.client.listLayouts((ListLayoutsRequest)((Object)ListLayoutsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

