/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Fields for audit event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditEventField implements SdkPojo, Serializable, ToCopyableBuilder<AuditEventField.Builder, AuditEventField> {
    private static final SdkField<String> EVENT_FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventFieldId").getter(getter(AuditEventField::eventFieldId)).setter(setter(Builder::eventFieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFieldId").build()).build();

    private static final SdkField<AuditEventFieldValueUnion> NEW_VALUE_FIELD = SdkField
            .<AuditEventFieldValueUnion> builder(MarshallingType.SDK_POJO).memberName("newValue")
            .getter(getter(AuditEventField::newValue)).setter(setter(Builder::newValue))
            .constructor(AuditEventFieldValueUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newValue").build()).build();

    private static final SdkField<AuditEventFieldValueUnion> OLD_VALUE_FIELD = SdkField
            .<AuditEventFieldValueUnion> builder(MarshallingType.SDK_POJO).memberName("oldValue")
            .getter(getter(AuditEventField::oldValue)).setter(setter(Builder::oldValue))
            .constructor(AuditEventFieldValueUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oldValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD_ID_FIELD,
            NEW_VALUE_FIELD, OLD_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventFieldId;

    private final AuditEventFieldValueUnion newValue;

    private final AuditEventFieldValueUnion oldValue;

    private AuditEventField(BuilderImpl builder) {
        this.eventFieldId = builder.eventFieldId;
        this.newValue = builder.newValue;
        this.oldValue = builder.oldValue;
    }

    /**
     * <p>
     * Unique identifier of field in an Audit History entry.
     * </p>
     * 
     * @return Unique identifier of field in an Audit History entry.
     */
    public final String eventFieldId() {
        return eventFieldId;
    }

    /**
     * <p>
     * Union of potential field value types.
     * </p>
     * 
     * @return Union of potential field value types.
     */
    public final AuditEventFieldValueUnion newValue() {
        return newValue;
    }

    /**
     * <p>
     * Union of potential field value types.
     * </p>
     * 
     * @return Union of potential field value types.
     */
    public final AuditEventFieldValueUnion oldValue() {
        return oldValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        hashCode = 31 * hashCode + Objects.hashCode(oldValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEventField)) {
            return false;
        }
        AuditEventField other = (AuditEventField) obj;
        return Objects.equals(eventFieldId(), other.eventFieldId()) && Objects.equals(newValue(), other.newValue())
                && Objects.equals(oldValue(), other.oldValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditEventField").add("EventFieldId", eventFieldId()).add("NewValue", newValue())
                .add("OldValue", oldValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventFieldId":
            return Optional.ofNullable(clazz.cast(eventFieldId()));
        case "newValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        case "oldValue":
            return Optional.ofNullable(clazz.cast(oldValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditEventField, T> g) {
        return obj -> g.apply((AuditEventField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditEventField> {
        /**
         * <p>
         * Unique identifier of field in an Audit History entry.
         * </p>
         * 
         * @param eventFieldId
         *        Unique identifier of field in an Audit History entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFieldId(String eventFieldId);

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * 
         * @param newValue
         *        Union of potential field value types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(AuditEventFieldValueUnion newValue);

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditEventFieldValueUnion.Builder}
         * avoiding the need to create one manually via {@link AuditEventFieldValueUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditEventFieldValueUnion.Builder#build()} is called immediately
         * and its result is passed to {@link #newValue(AuditEventFieldValueUnion)}.
         * 
         * @param newValue
         *        a consumer that will call methods on {@link AuditEventFieldValueUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newValue(AuditEventFieldValueUnion)
         */
        default Builder newValue(Consumer<AuditEventFieldValueUnion.Builder> newValue) {
            return newValue(AuditEventFieldValueUnion.builder().applyMutation(newValue).build());
        }

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * 
         * @param oldValue
         *        Union of potential field value types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldValue(AuditEventFieldValueUnion oldValue);

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditEventFieldValueUnion.Builder}
         * avoiding the need to create one manually via {@link AuditEventFieldValueUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditEventFieldValueUnion.Builder#build()} is called immediately
         * and its result is passed to {@link #oldValue(AuditEventFieldValueUnion)}.
         * 
         * @param oldValue
         *        a consumer that will call methods on {@link AuditEventFieldValueUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oldValue(AuditEventFieldValueUnion)
         */
        default Builder oldValue(Consumer<AuditEventFieldValueUnion.Builder> oldValue) {
            return oldValue(AuditEventFieldValueUnion.builder().applyMutation(oldValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String eventFieldId;

        private AuditEventFieldValueUnion newValue;

        private AuditEventFieldValueUnion oldValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEventField model) {
            eventFieldId(model.eventFieldId);
            newValue(model.newValue);
            oldValue(model.oldValue);
        }

        public final String getEventFieldId() {
            return eventFieldId;
        }

        public final void setEventFieldId(String eventFieldId) {
            this.eventFieldId = eventFieldId;
        }

        @Override
        public final Builder eventFieldId(String eventFieldId) {
            this.eventFieldId = eventFieldId;
            return this;
        }

        public final AuditEventFieldValueUnion.Builder getNewValue() {
            return newValue != null ? newValue.toBuilder() : null;
        }

        public final void setNewValue(AuditEventFieldValueUnion.BuilderImpl newValue) {
            this.newValue = newValue != null ? newValue.build() : null;
        }

        @Override
        public final Builder newValue(AuditEventFieldValueUnion newValue) {
            this.newValue = newValue;
            return this;
        }

        public final AuditEventFieldValueUnion.Builder getOldValue() {
            return oldValue != null ? oldValue.toBuilder() : null;
        }

        public final void setOldValue(AuditEventFieldValueUnion.BuilderImpl oldValue) {
            this.oldValue = oldValue != null ? oldValue.build() : null;
        }

        @Override
        public final Builder oldValue(AuditEventFieldValueUnion oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        @Override
        public AuditEventField build() {
            return new AuditEventField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
