/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.LayoutConfiguration;
import software.amazon.awssdk.services.connectcases.model.RequiredField;
import software.amazon.awssdk.services.connectcases.model.RequiredFieldListCopier;
import software.amazon.awssdk.services.connectcases.model.TagsCopier;
import software.amazon.awssdk.services.connectcases.model.TemplateCaseRuleListCopier;
import software.amazon.awssdk.services.connectcases.model.TemplateRule;
import software.amazon.awssdk.services.connectcases.model.TemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(GetTemplateResponse.getter(GetTemplateResponse::createdTime)).setter(GetTemplateResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleted").getter(GetTemplateResponse.getter(GetTemplateResponse::deleted)).setter(GetTemplateResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTemplateResponse.getter(GetTemplateResponse::description)).setter(GetTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetTemplateResponse.getter(GetTemplateResponse::lastModifiedTime)).setter(GetTemplateResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<LayoutConfiguration> LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("layoutConfiguration").getter(GetTemplateResponse.getter(GetTemplateResponse::layoutConfiguration)).setter(GetTemplateResponse.setter(Builder::layoutConfiguration)).constructor(LayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTemplateResponse.getter(GetTemplateResponse::name)).setter(GetTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<RequiredField>> REQUIRED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFields").getter(GetTemplateResponse.getter(GetTemplateResponse::requiredFields)).setter(GetTemplateResponse.setter(Builder::requiredFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequiredField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TemplateRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(GetTemplateResponse.getter(GetTemplateResponse::rules)).setter(GetTemplateResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTemplateResponse.getter(GetTemplateResponse::statusAsString)).setter(GetTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTemplateResponse.getter(GetTemplateResponse::tags)).setter(GetTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(GetTemplateResponse.getter(GetTemplateResponse::templateArn)).setter(GetTemplateResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(GetTemplateResponse.getter(GetTemplateResponse::templateId)).setter(GetTemplateResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, DELETED_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD, LAYOUT_CONFIGURATION_FIELD, NAME_FIELD, REQUIRED_FIELDS_FIELD, RULES_FIELD, STATUS_FIELD, TAGS_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemplateResponse.memberNameToFieldInitializer();
    private final Instant createdTime;
    private final Boolean deleted;
    private final String description;
    private final Instant lastModifiedTime;
    private final LayoutConfiguration layoutConfiguration;
    private final String name;
    private final List<RequiredField> requiredFields;
    private final List<TemplateRule> rules;
    private final String status;
    private final Map<String, String> tags;
    private final String templateArn;
    private final String templateId;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.layoutConfiguration = builder.layoutConfiguration;
        this.name = builder.name;
        this.requiredFields = builder.requiredFields;
        this.rules = builder.rules;
        this.status = builder.status;
        this.tags = builder.tags;
        this.templateArn = builder.templateArn;
        this.templateId = builder.templateId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Boolean deleted() {
        return this.deleted;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final LayoutConfiguration layoutConfiguration() {
        return this.layoutConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRequiredFields() {
        return this.requiredFields != null && !(this.requiredFields instanceof SdkAutoConstructList);
    }

    public final List<RequiredField> requiredFields() {
        return this.requiredFields;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<TemplateRule> rules() {
        return this.rules;
    }

    public final TemplateStatus status() {
        return TemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateId() {
        return this.templateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFields() ? this.requiredFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.layoutConfiguration(), other.layoutConfiguration()) && Objects.equals(this.name(), other.name()) && this.hasRequiredFields() == other.hasRequiredFields() && Objects.equals(this.requiredFields(), other.requiredFields()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateId(), other.templateId());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("CreatedTime", (Object)this.createdTime()).add("Deleted", (Object)this.deleted()).add("Description", (Object)this.description()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LayoutConfiguration", (Object)this.layoutConfiguration()).add("Name", (Object)this.name()).add("RequiredFields", this.hasRequiredFields() ? this.requiredFields() : null).add("Rules", this.hasRules() ? this.rules() : null).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateArn", (Object)this.templateArn()).add("TemplateId", (Object)this.templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "layoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.layoutConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requiredFields": {
                return Optional.ofNullable(clazz.cast(this.requiredFields()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("layoutConfiguration", LAYOUT_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requiredFields", REQUIRED_FIELDS_FIELD);
        map.put("rules", RULES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private Instant createdTime;
        private Boolean deleted;
        private String description;
        private Instant lastModifiedTime;
        private LayoutConfiguration layoutConfiguration;
        private String name;
        private List<RequiredField> requiredFields = DefaultSdkAutoConstructList.getInstance();
        private List<TemplateRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateArn;
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.createdTime(model.createdTime);
            this.deleted(model.deleted);
            this.description(model.description);
            this.lastModifiedTime(model.lastModifiedTime);
            this.layoutConfiguration(model.layoutConfiguration);
            this.name(model.name);
            this.requiredFields(model.requiredFields);
            this.rules(model.rules);
            this.status(model.status);
            this.tags(model.tags);
            this.templateArn(model.templateArn);
            this.templateId(model.templateId);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final LayoutConfiguration.Builder getLayoutConfiguration() {
            return this.layoutConfiguration != null ? this.layoutConfiguration.toBuilder() : null;
        }

        public final void setLayoutConfiguration(LayoutConfiguration.BuilderImpl layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration != null ? layoutConfiguration.build() : null;
        }

        @Override
        public final Builder layoutConfiguration(LayoutConfiguration layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RequiredField.Builder> getRequiredFields() {
            List<RequiredField.Builder> result = RequiredFieldListCopier.copyToBuilder(this.requiredFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredFields(Collection<RequiredField.BuilderImpl> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copyFromBuilder(requiredFields);
        }

        @Override
        public final Builder requiredFields(Collection<RequiredField> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copy(requiredFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(RequiredField ... requiredFields) {
            this.requiredFields(Arrays.asList(requiredFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(Consumer<RequiredField.Builder> ... requiredFields) {
            this.requiredFields(Stream.of(requiredFields).map(c -> (RequiredField)((RequiredField.Builder)RequiredField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TemplateRule.Builder> getRules() {
            List<TemplateRule.Builder> result = TemplateCaseRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<TemplateRule.BuilderImpl> rules) {
            this.rules = TemplateCaseRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<TemplateRule> rules) {
            this.rules = TemplateCaseRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(TemplateRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<TemplateRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (TemplateRule)((TemplateRule.Builder)TemplateRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder createdTime(Instant var1);

        public Builder deleted(Boolean var1);

        public Builder description(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder layoutConfiguration(LayoutConfiguration var1);

        default public Builder layoutConfiguration(Consumer<LayoutConfiguration.Builder> layoutConfiguration) {
            return this.layoutConfiguration((LayoutConfiguration)((LayoutConfiguration.Builder)LayoutConfiguration.builder().applyMutation(layoutConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder requiredFields(Collection<RequiredField> var1);

        public Builder requiredFields(RequiredField ... var1);

        public Builder requiredFields(Consumer<RequiredField.Builder> ... var1);

        public Builder rules(Collection<TemplateRule> var1);

        public Builder rules(TemplateRule ... var1);

        public Builder rules(Consumer<TemplateRule.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TemplateStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateArn(String var1);

        public Builder templateId(String var1);
    }
}

