/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object to store union of Field values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditEventFieldValueUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditEventFieldValueUnion.Builder, AuditEventFieldValueUnion> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(AuditEventFieldValueUnion::booleanValue))
            .setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(AuditEventFieldValueUnion::doubleValue))
            .setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<EmptyFieldValue> EMPTY_VALUE_FIELD = SdkField
            .<EmptyFieldValue> builder(MarshallingType.SDK_POJO).memberName("emptyValue")
            .getter(getter(AuditEventFieldValueUnion::emptyValue)).setter(setter(Builder::emptyValue))
            .constructor(EmptyFieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(AuditEventFieldValueUnion::stringValue))
            .setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<String> USER_ARN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArnValue").getter(getter(AuditEventFieldValueUnion::userArnValue))
            .setter(setter(Builder::userArnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArnValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD,
            DOUBLE_VALUE_FIELD, EMPTY_VALUE_FIELD, STRING_VALUE_FIELD, USER_ARN_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean booleanValue;

    private final Double doubleValue;

    private final EmptyFieldValue emptyValue;

    private final String stringValue;

    private final String userArnValue;

    private final Type type;

    private AuditEventFieldValueUnion(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.emptyValue = builder.emptyValue;
        this.stringValue = builder.stringValue;
        this.userArnValue = builder.userArnValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * Can be either null, or have a Boolean value type. Only one value can be provided.
     * </p>
     * 
     * @return Can be either null, or have a Boolean value type. Only one value can be provided.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * Can be either null, or have a Double value type. Only one value can be provided.
     * </p>
     * 
     * @return Can be either null, or have a Double value type. Only one value can be provided.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * Returns the value of the EmptyValue property for this object.
     * 
     * @return The value of the EmptyValue property for this object.
     */
    public final EmptyFieldValue emptyValue() {
        return emptyValue;
    }

    /**
     * <p>
     * Can be either null, or have a String value type. Only one value can be provided.
     * </p>
     * 
     * @return Can be either null, or have a String value type. Only one value can be provided.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
     * </p>
     * 
     * @return Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
     */
    public final String userArnValue() {
        return userArnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(emptyValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(userArnValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEventFieldValueUnion)) {
            return false;
        }
        AuditEventFieldValueUnion other = (AuditEventFieldValueUnion) obj;
        return Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(emptyValue(), other.emptyValue()) && Objects.equals(stringValue(), other.stringValue())
                && Objects.equals(userArnValue(), other.userArnValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditEventFieldValueUnion").add("BooleanValue", booleanValue())
                .add("DoubleValue", doubleValue()).add("EmptyValue", emptyValue()).add("StringValue", stringValue())
                .add("UserArnValue", userArnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "emptyValue":
            return Optional.ofNullable(clazz.cast(emptyValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "userArnValue":
            return Optional.ofNullable(clazz.cast(userArnValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * Can be either null, or have a Boolean value type. Only one value can be provided.
     * </p>
     * 
     * @param booleanValue
     *        Can be either null, or have a Boolean value type. Only one value can be provided.
     */
    public static AuditEventFieldValueUnion fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * Can be either null, or have a Double value type. Only one value can be provided.
     * </p>
     * 
     * @param doubleValue
     *        Can be either null, or have a Double value type. Only one value can be provided.
     */
    public static AuditEventFieldValueUnion fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #emptyValue()} initialized to the given value.
     *
     * Sets the value of the EmptyValue property for this object.
     *
     * @param emptyValue
     *        The new value for the EmptyValue property for this object.
     */
    public static AuditEventFieldValueUnion fromEmptyValue(EmptyFieldValue emptyValue) {
        return builder().emptyValue(emptyValue).build();
    }

    /**
     * Create an instance of this class with {@link #emptyValue()} initialized to the given value.
     *
     * Sets the value of the EmptyValue property for this object.
     *
     * @param emptyValue
     *        The new value for the EmptyValue property for this object.
     */
    public static AuditEventFieldValueUnion fromEmptyValue(Consumer<EmptyFieldValue.Builder> emptyValue) {
        EmptyFieldValue.Builder builder = EmptyFieldValue.builder();
        emptyValue.accept(builder);
        return fromEmptyValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * Can be either null, or have a String value type. Only one value can be provided.
     * </p>
     * 
     * @param stringValue
     *        Can be either null, or have a String value type. Only one value can be provided.
     */
    public static AuditEventFieldValueUnion fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #userArnValue()} initialized to the given value.
     *
     * <p>
     * Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
     * </p>
     * 
     * @param userArnValue
     *        Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
     */
    public static AuditEventFieldValueUnion fromUserArnValue(String userArnValue) {
        return builder().userArnValue(userArnValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("booleanValue", BOOLEAN_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("emptyValue", EMPTY_VALUE_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("userArnValue", USER_ARN_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditEventFieldValueUnion, T> g) {
        return obj -> g.apply((AuditEventFieldValueUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditEventFieldValueUnion> {
        /**
         * <p>
         * Can be either null, or have a Boolean value type. Only one value can be provided.
         * </p>
         * 
         * @param booleanValue
         *        Can be either null, or have a Boolean value type. Only one value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * Can be either null, or have a Double value type. Only one value can be provided.
         * </p>
         * 
         * @param doubleValue
         *        Can be either null, or have a Double value type. Only one value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * Sets the value of the EmptyValue property for this object.
         *
         * @param emptyValue
         *        The new value for the EmptyValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyValue(EmptyFieldValue emptyValue);

        /**
         * Sets the value of the EmptyValue property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EmptyFieldValue.Builder} avoiding the
         * need to create one manually via {@link EmptyFieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmptyFieldValue.Builder#build()} is called immediately and its
         * result is passed to {@link #emptyValue(EmptyFieldValue)}.
         * 
         * @param emptyValue
         *        a consumer that will call methods on {@link EmptyFieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emptyValue(EmptyFieldValue)
         */
        default Builder emptyValue(Consumer<EmptyFieldValue.Builder> emptyValue) {
            return emptyValue(EmptyFieldValue.builder().applyMutation(emptyValue).build());
        }

        /**
         * <p>
         * Can be either null, or have a String value type. Only one value can be provided.
         * </p>
         * 
         * @param stringValue
         *        Can be either null, or have a String value type. Only one value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
         * </p>
         * 
         * @param userArnValue
         *        Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArnValue(String userArnValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean booleanValue;

        private Double doubleValue;

        private EmptyFieldValue emptyValue;

        private String stringValue;

        private String userArnValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEventFieldValueUnion model) {
            booleanValue(model.booleanValue);
            doubleValue(model.doubleValue);
            emptyValue(model.emptyValue);
            stringValue(model.stringValue);
            userArnValue(model.userArnValue);
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final EmptyFieldValue.Builder getEmptyValue() {
            return emptyValue != null ? emptyValue.toBuilder() : null;
        }

        public final void setEmptyValue(EmptyFieldValue.BuilderImpl emptyValue) {
            Object oldValue = this.emptyValue;
            this.emptyValue = emptyValue != null ? emptyValue.build() : null;
            handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
        }

        @Override
        public final Builder emptyValue(EmptyFieldValue emptyValue) {
            Object oldValue = this.emptyValue;
            this.emptyValue = emptyValue;
            handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final String getUserArnValue() {
            return userArnValue;
        }

        public final void setUserArnValue(String userArnValue) {
            Object oldValue = this.userArnValue;
            this.userArnValue = userArnValue;
            handleUnionValueChange(Type.USER_ARN_VALUE, oldValue, this.userArnValue);
        }

        @Override
        public final Builder userArnValue(String userArnValue) {
            Object oldValue = this.userArnValue;
            this.userArnValue = userArnValue;
            handleUnionValueChange(Type.USER_ARN_VALUE, oldValue, this.userArnValue);
            return this;
        }

        @Override
        public AuditEventFieldValueUnion build() {
            return new AuditEventFieldValueUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AuditEventFieldValueUnion#type()
     */
    public enum Type {
        BOOLEAN_VALUE,

        DOUBLE_VALUE,

        EMPTY_VALUE,

        STRING_VALUE,

        USER_ARN_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
