/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for cases. Only one value can be provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseFilter implements SdkPojo, Serializable, ToCopyableBuilder<CaseFilter.Builder, CaseFilter> {
    private static final SdkField<List<CaseFilter>> AND_ALL_FIELD = SdkField
            .<List<CaseFilter>> builder(MarshallingType.LIST)
            .memberName("andAll")
            .getter(getter(CaseFilter::andAll))
            .setter(setter(Builder::andAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FieldFilter> FIELD_FIELD = SdkField.<FieldFilter> builder(MarshallingType.SDK_POJO)
            .memberName("field").getter(getter(CaseFilter::field)).setter(setter(Builder::field))
            .constructor(FieldFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<CaseFilter> NOT_FIELD = SdkField.<CaseFilter> builder(MarshallingType.SDK_POJO)
            .memberName("not").getter(getter(CaseFilter::not)).setter(setter(Builder::not)).constructor(CaseFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("not").build()).build();

    private static final SdkField<List<CaseFilter>> OR_ALL_FIELD = SdkField
            .<List<CaseFilter>> builder(MarshallingType.LIST)
            .memberName("orAll")
            .getter(getter(CaseFilter::orAll))
            .setter(setter(Builder::orAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_ALL_FIELD, FIELD_FIELD,
            NOT_FIELD, OR_ALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CaseFilter> andAll;

    private final FieldFilter field;

    private final CaseFilter not;

    private final List<CaseFilter> orAll;

    private final Type type;

    private CaseFilter(BuilderImpl builder) {
        this.andAll = builder.andAll;
        this.field = builder.field;
        this.not = builder.not;
        this.orAll = builder.orAll;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAll property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAndAll() {
        return andAll != null && !(andAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides "and all" filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAll} method.
     * </p>
     * 
     * @return Provides "and all" filtering.
     */
    public final List<CaseFilter> andAll() {
        return andAll;
    }

    /**
     * <p>
     * A list of fields to filter on.
     * </p>
     * 
     * @return A list of fields to filter on.
     */
    public final FieldFilter field() {
        return field;
    }

    /**
     * Returns the value of the Not property for this object.
     * 
     * @return The value of the Not property for this object.
     */
    public final CaseFilter not() {
        return not;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAll property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrAll() {
        return orAll != null && !(orAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides "or all" filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAll} method.
     * </p>
     * 
     * @return Provides "or all" filtering.
     */
    public final List<CaseFilter> orAll() {
        return orAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAll() ? andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(not());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAll() ? orAll() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseFilter)) {
            return false;
        }
        CaseFilter other = (CaseFilter) obj;
        return hasAndAll() == other.hasAndAll() && Objects.equals(andAll(), other.andAll())
                && Objects.equals(field(), other.field()) && Objects.equals(not(), other.not()) && hasOrAll() == other.hasOrAll()
                && Objects.equals(orAll(), other.orAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseFilter").add("AndAll", hasAndAll() ? andAll() : null).add("Field", field())
                .add("Not", not()).add("OrAll", hasOrAll() ? orAll() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "andAll":
            return Optional.ofNullable(clazz.cast(andAll()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        case "not":
            return Optional.ofNullable(clazz.cast(not()));
        case "orAll":
            return Optional.ofNullable(clazz.cast(orAll()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #andAll()} initialized to the given value.
     *
     * <p>
     * Provides "and all" filtering.
     * </p>
     * 
     * @param andAll
     *        Provides "and all" filtering.
     */
    public static CaseFilter fromAndAll(List<CaseFilter> andAll) {
        return builder().andAll(andAll).build();
    }

    /**
     * Create an instance of this class with {@link #field()} initialized to the given value.
     *
     * <p>
     * A list of fields to filter on.
     * </p>
     * 
     * @param field
     *        A list of fields to filter on.
     */
    public static CaseFilter fromField(FieldFilter field) {
        return builder().field(field).build();
    }

    /**
     * Create an instance of this class with {@link #field()} initialized to the given value.
     *
     * <p>
     * A list of fields to filter on.
     * </p>
     * 
     * @param field
     *        A list of fields to filter on.
     */
    public static CaseFilter fromField(Consumer<FieldFilter.Builder> field) {
        FieldFilter.Builder builder = FieldFilter.builder();
        field.accept(builder);
        return fromField(builder.build());
    }

    /**
     * Create an instance of this class with {@link #not()} initialized to the given value.
     *
     * Sets the value of the Not property for this object.
     *
     * @param not
     *        The new value for the Not property for this object.
     */
    public static CaseFilter fromNot(CaseFilter not) {
        return builder().not(not).build();
    }

    /**
     * Create an instance of this class with {@link #not()} initialized to the given value.
     *
     * Sets the value of the Not property for this object.
     *
     * @param not
     *        The new value for the Not property for this object.
     */
    public static CaseFilter fromNot(Consumer<Builder> not) {
        Builder builder = CaseFilter.builder();
        not.accept(builder);
        return fromNot(builder.build());
    }

    /**
     * Create an instance of this class with {@link #orAll()} initialized to the given value.
     *
     * <p>
     * Provides "or all" filtering.
     * </p>
     * 
     * @param orAll
     *        Provides "or all" filtering.
     */
    public static CaseFilter fromOrAll(List<CaseFilter> orAll) {
        return builder().orAll(orAll).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("andAll", AND_ALL_FIELD);
        map.put("field", FIELD_FIELD);
        map.put("not", NOT_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseFilter, T> g) {
        return obj -> g.apply((CaseFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseFilter> {
        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * 
         * @param andAll
         *        Provides "and all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(Collection<CaseFilter> andAll);

        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * 
         * @param andAll
         *        Provides "and all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(CaseFilter... andAll);

        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.CaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #andAll(List<CaseFilter>)}.
         * 
         * @param andAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAll(java.util.Collection<CaseFilter>)
         */
        Builder andAll(Consumer<Builder>... andAll);

        /**
         * <p>
         * A list of fields to filter on.
         * </p>
         * 
         * @param field
         *        A list of fields to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(FieldFilter field);

        /**
         * <p>
         * A list of fields to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldFilter.Builder} avoiding the need to
         * create one manually via {@link FieldFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #field(FieldFilter)}.
         * 
         * @param field
         *        a consumer that will call methods on {@link FieldFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #field(FieldFilter)
         */
        default Builder field(Consumer<FieldFilter.Builder> field) {
            return field(FieldFilter.builder().applyMutation(field).build());
        }

        /**
         * Sets the value of the Not property for this object.
         *
         * @param not
         *        The new value for the Not property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder not(CaseFilter not);

        /**
         * Sets the value of the Not property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CaseFilter.Builder} avoiding the need to
         * create one manually via {@link CaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #not(CaseFilter)}.
         * 
         * @param not
         *        a consumer that will call methods on {@link CaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #not(CaseFilter)
         */
        default Builder not(Consumer<Builder> not) {
            return not(CaseFilter.builder().applyMutation(not).build());
        }

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * 
         * @param orAll
         *        Provides "or all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(Collection<CaseFilter> orAll);

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * 
         * @param orAll
         *        Provides "or all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(CaseFilter... orAll);

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.CaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #orAll(List<CaseFilter>)}.
         * 
         * @param orAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAll(java.util.Collection<CaseFilter>)
         */
        Builder orAll(Consumer<Builder>... orAll);
    }

    static final class BuilderImpl implements Builder {
        private List<CaseFilter> andAll = DefaultSdkAutoConstructList.getInstance();

        private FieldFilter field;

        private CaseFilter not;

        private List<CaseFilter> orAll = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CaseFilter model) {
            andAll(model.andAll);
            field(model.field);
            not(model.not);
            orAll(model.orAll);
        }

        public final List<Builder> getAndAll() {
            List<Builder> result = CaseFilterAndAllListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<BuilderImpl> andAll) {
            Object oldValue = this.andAll;
            this.andAll = CaseFilterAndAllListCopier.copyFromBuilder(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<CaseFilter> andAll) {
            Object oldValue = this.andAll;
            this.andAll = CaseFilterAndAllListCopier.copy(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(CaseFilter... andAll) {
            andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<Builder>... andAll) {
            andAll(Stream.of(andAll).map(c -> CaseFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final FieldFilter.Builder getField() {
            return field != null ? field.toBuilder() : null;
        }

        public final void setField(FieldFilter.BuilderImpl field) {
            Object oldValue = this.field;
            this.field = field != null ? field.build() : null;
            handleUnionValueChange(Type.FIELD, oldValue, this.field);
        }

        @Override
        public final Builder field(FieldFilter field) {
            Object oldValue = this.field;
            this.field = field;
            handleUnionValueChange(Type.FIELD, oldValue, this.field);
            return this;
        }

        public final Builder getNot() {
            return not != null ? not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            Object oldValue = this.not;
            this.not = not != null ? not.build() : null;
            handleUnionValueChange(Type.NOT, oldValue, this.not);
        }

        @Override
        public final Builder not(CaseFilter not) {
            Object oldValue = this.not;
            this.not = not;
            handleUnionValueChange(Type.NOT, oldValue, this.not);
            return this;
        }

        public final List<Builder> getOrAll() {
            List<Builder> result = CaseFilterOrAllListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<BuilderImpl> orAll) {
            Object oldValue = this.orAll;
            this.orAll = CaseFilterOrAllListCopier.copyFromBuilder(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<CaseFilter> orAll) {
            Object oldValue = this.orAll;
            this.orAll = CaseFilterOrAllListCopier.copy(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(CaseFilter... orAll) {
            orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<Builder>... orAll) {
            orAll(Stream.of(orAll).map(c -> CaseFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CaseFilter build() {
            return new CaseFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CaseFilter#type()
     */
    public enum Type {
        AND_ALL,

        FIELD,

        NOT,

        OR_ALL,

        UNKNOWN_TO_SDK_VERSION
    }
}
