/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the content of a <code>Comment</code> to be returned to agents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommentContent implements SdkPojo, Serializable, ToCopyableBuilder<CommentContent.Builder, CommentContent> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(CommentContent::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(CommentContent::contentTypeAsString)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BODY_FIELD, CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String contentType;

    private CommentContent(BuilderImpl builder) {
        this.body = builder.body;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * Text in the body of a <code>Comment</code> on a case.
     * </p>
     * 
     * @return Text in the body of a <code>Comment</code> on a case.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * Type of the text in the box of a <code>Comment</code> on a case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CommentBodyTextType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Type of the text in the box of a <code>Comment</code> on a case.
     * @see CommentBodyTextType
     */
    public final CommentBodyTextType contentType() {
        return CommentBodyTextType.fromValue(contentType);
    }

    /**
     * <p>
     * Type of the text in the box of a <code>Comment</code> on a case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CommentBodyTextType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Type of the text in the box of a <code>Comment</code> on a case.
     * @see CommentBodyTextType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentContent)) {
            return false;
        }
        CommentContent other = (CommentContent) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(contentTypeAsString(), other.contentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommentContent").add("Body", body()).add("ContentType", contentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommentContent, T> g) {
        return obj -> g.apply((CommentContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommentContent> {
        /**
         * <p>
         * Text in the body of a <code>Comment</code> on a case.
         * </p>
         * 
         * @param body
         *        Text in the body of a <code>Comment</code> on a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * Type of the text in the box of a <code>Comment</code> on a case.
         * </p>
         * 
         * @param contentType
         *        Type of the text in the box of a <code>Comment</code> on a case.
         * @see CommentBodyTextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentBodyTextType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Type of the text in the box of a <code>Comment</code> on a case.
         * </p>
         * 
         * @param contentType
         *        Type of the text in the box of a <code>Comment</code> on a case.
         * @see CommentBodyTextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentBodyTextType
         */
        Builder contentType(CommentBodyTextType contentType);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CommentContent model) {
            body(model.body);
            contentType(model.contentType);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CommentBodyTextType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        @Override
        public CommentContent build() {
            return new CommentContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
