/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a content of an Amazon Connect contact object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactContent implements SdkPojo, Serializable, ToCopyableBuilder<ContactContent.Builder, ContactContent> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("channel")
            .getter(getter(ContactContent::channel)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<Instant> CONNECTED_TO_SYSTEM_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("connectedToSystemTime")
            .getter(getter(ContactContent::connectedToSystemTime))
            .setter(setter(Builder::connectedToSystemTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectedToSystemTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactArn").getter(getter(ContactContent::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            CONNECTED_TO_SYSTEM_TIME_FIELD, CONTACT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channel;

    private final Instant connectedToSystemTime;

    private final String contactArn;

    private ContactContent(BuilderImpl builder) {
        this.channel = builder.channel;
        this.connectedToSystemTime = builder.connectedToSystemTime;
        this.contactArn = builder.contactArn;
    }

    /**
     * <p>
     * A list of channels to filter on for related items of type <code>Contact</code>.
     * </p>
     * 
     * @return A list of channels to filter on for related items of type <code>Contact</code>.
     */
    public final String channel() {
        return channel;
    }

    /**
     * <p>
     * The difference between the <code>InitiationTimestamp</code> and the <code>DisconnectTimestamp</code> of the
     * contact.
     * </p>
     * 
     * @return The difference between the <code>InitiationTimestamp</code> and the <code>DisconnectTimestamp</code> of
     *         the contact.
     */
    public final Instant connectedToSystemTime() {
        return connectedToSystemTime;
    }

    /**
     * <p>
     * A unique identifier of a contact in Amazon Connect.
     * </p>
     * 
     * @return A unique identifier of a contact in Amazon Connect.
     */
    public final String contactArn() {
        return contactArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(connectedToSystemTime());
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactContent)) {
            return false;
        }
        ContactContent other = (ContactContent) obj;
        return Objects.equals(channel(), other.channel())
                && Objects.equals(connectedToSystemTime(), other.connectedToSystemTime())
                && Objects.equals(contactArn(), other.contactArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactContent").add("Channel", channel()).add("ConnectedToSystemTime", connectedToSystemTime())
                .add("ContactArn", contactArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "connectedToSystemTime":
            return Optional.ofNullable(clazz.cast(connectedToSystemTime()));
        case "contactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channel", CHANNEL_FIELD);
        map.put("connectedToSystemTime", CONNECTED_TO_SYSTEM_TIME_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactContent, T> g) {
        return obj -> g.apply((ContactContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactContent> {
        /**
         * <p>
         * A list of channels to filter on for related items of type <code>Contact</code>.
         * </p>
         * 
         * @param channel
         *        A list of channels to filter on for related items of type <code>Contact</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String channel);

        /**
         * <p>
         * The difference between the <code>InitiationTimestamp</code> and the <code>DisconnectTimestamp</code> of the
         * contact.
         * </p>
         * 
         * @param connectedToSystemTime
         *        The difference between the <code>InitiationTimestamp</code> and the <code>DisconnectTimestamp</code>
         *        of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedToSystemTime(Instant connectedToSystemTime);

        /**
         * <p>
         * A unique identifier of a contact in Amazon Connect.
         * </p>
         * 
         * @param contactArn
         *        A unique identifier of a contact in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);
    }

    static final class BuilderImpl implements Builder {
        private String channel;

        private Instant connectedToSystemTime;

        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactContent model) {
            channel(model.channel);
            connectedToSystemTime(model.connectedToSystemTime);
            contactArn(model.contactArn);
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final Instant getConnectedToSystemTime() {
            return connectedToSystemTime;
        }

        public final void setConnectedToSystemTime(Instant connectedToSystemTime) {
            this.connectedToSystemTime = connectedToSystemTime;
        }

        @Override
        public final Builder connectedToSystemTime(Instant connectedToSystemTime) {
            this.connectedToSystemTime = connectedToSystemTime;
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        @Override
        public ContactContent build() {
            return new ContactContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
