/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFieldResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<CreateFieldResponse.Builder, CreateFieldResponse> {
    private static final SdkField<String> FIELD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldArn").getter(getter(CreateFieldResponse::fieldArn)).setter(setter(Builder::fieldArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldArn").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldId").getter(getter(CreateFieldResponse::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ARN_FIELD,
            FIELD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fieldArn;

    private final String fieldId;

    private CreateFieldResponse(BuilderImpl builder) {
        super(builder);
        this.fieldArn = builder.fieldArn;
        this.fieldId = builder.fieldId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the field.
     */
    public final String fieldArn() {
        return fieldArn;
    }

    /**
     * <p>
     * The unique identifier of a field.
     * </p>
     * 
     * @return The unique identifier of a field.
     */
    public final String fieldId() {
        return fieldId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldArn());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFieldResponse)) {
            return false;
        }
        CreateFieldResponse other = (CreateFieldResponse) obj;
        return Objects.equals(fieldArn(), other.fieldArn()) && Objects.equals(fieldId(), other.fieldId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFieldResponse").add("FieldArn", fieldArn()).add("FieldId", fieldId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldArn":
            return Optional.ofNullable(clazz.cast(fieldArn()));
        case "fieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldArn", FIELD_ARN_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFieldResponse, T> g) {
        return obj -> g.apply((CreateFieldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFieldResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the field.
         * </p>
         * 
         * @param fieldArn
         *        The Amazon Resource Name (ARN) of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldArn(String fieldArn);

        /**
         * <p>
         * The unique identifier of a field.
         * </p>
         * 
         * @param fieldId
         *        The unique identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private String fieldArn;

        private String fieldId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFieldResponse model) {
            super(model);
            fieldArn(model.fieldArn);
            fieldId(model.fieldId);
        }

        public final String getFieldArn() {
            return fieldArn;
        }

        public final void setFieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
        }

        @Override
        public final Builder fieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        @Override
        public CreateFieldResponse build() {
            return new CreateFieldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
