/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLayoutResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<CreateLayoutResponse.Builder, CreateLayoutResponse> {
    private static final SdkField<String> LAYOUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutArn").getter(getter(CreateLayoutResponse::layoutArn)).setter(setter(Builder::layoutArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutArn").build()).build();

    private static final SdkField<String> LAYOUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutId").getter(getter(CreateLayoutResponse::layoutId)).setter(setter(Builder::layoutId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_ARN_FIELD,
            LAYOUT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String layoutArn;

    private final String layoutId;

    private CreateLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.layoutArn = builder.layoutArn;
        this.layoutId = builder.layoutId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the newly created layout.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the newly created layout.
     */
    public final String layoutArn() {
        return layoutArn;
    }

    /**
     * <p>
     * The unique identifier of the layout.
     * </p>
     * 
     * @return The unique identifier of the layout.
     */
    public final String layoutId() {
        return layoutId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layoutArn());
        hashCode = 31 * hashCode + Objects.hashCode(layoutId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayoutResponse)) {
            return false;
        }
        CreateLayoutResponse other = (CreateLayoutResponse) obj;
        return Objects.equals(layoutArn(), other.layoutArn()) && Objects.equals(layoutId(), other.layoutId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLayoutResponse").add("LayoutArn", layoutArn()).add("LayoutId", layoutId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layoutArn":
            return Optional.ofNullable(clazz.cast(layoutArn()));
        case "layoutId":
            return Optional.ofNullable(clazz.cast(layoutId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("layoutArn", LAYOUT_ARN_FIELD);
        map.put("layoutId", LAYOUT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLayoutResponse, T> g) {
        return obj -> g.apply((CreateLayoutResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLayoutResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the newly created layout.
         * </p>
         * 
         * @param layoutArn
         *        The Amazon Resource Name (ARN) of the newly created layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutArn(String layoutArn);

        /**
         * <p>
         * The unique identifier of the layout.
         * </p>
         * 
         * @param layoutId
         *        The unique identifier of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutId(String layoutId);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private String layoutArn;

        private String layoutId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayoutResponse model) {
            super(model);
            layoutArn(model.layoutArn);
            layoutId(model.layoutId);
        }

        public final String getLayoutArn() {
            return layoutArn;
        }

        public final void setLayoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
        }

        @Override
        public final Builder layoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
            return this;
        }

        public final String getLayoutId() {
            return layoutId;
        }

        public final void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final Builder layoutId(String layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        @Override
        public CreateLayoutResponse build() {
            return new CreateLayoutResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
