/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelatedItemRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<CreateRelatedItemRequest.Builder, CreateRelatedItemRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(CreateRelatedItemRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()).build();

    private static final SdkField<RelatedItemInputContent> CONTENT_FIELD = SdkField
            .<RelatedItemInputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(CreateRelatedItemRequest::content)).setter(setter(Builder::content))
            .constructor(RelatedItemInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateRelatedItemRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<UserUnion> PERFORMED_BY_FIELD = SdkField.<UserUnion> builder(MarshallingType.SDK_POJO)
            .memberName("performedBy").getter(getter(CreateRelatedItemRequest::performedBy)).setter(setter(Builder::performedBy))
            .constructor(UserUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateRelatedItemRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, CONTENT_FIELD,
            DOMAIN_ID_FIELD, PERFORMED_BY_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final RelatedItemInputContent content;

    private final String domainId;

    private final UserUnion performedBy;

    private final String type;

    private CreateRelatedItemRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.content = builder.content;
        this.domainId = builder.domainId;
        this.performedBy = builder.performedBy;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique identifier of the case.
     * </p>
     * 
     * @return A unique identifier of the case.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The content of a related item to be created.
     * </p>
     * 
     * @return The content of a related item to be created.
     */
    public final RelatedItemInputContent content() {
        return content;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Represents the creator of the related item.
     * </p>
     * 
     * @return Represents the creator of the related item.
     */
    public final UserUnion performedBy() {
        return performedBy;
    }

    /**
     * <p>
     * The type of a related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a related item.
     * @see RelatedItemType
     */
    public final RelatedItemType type() {
        return RelatedItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of a related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a related item.
     * @see RelatedItemType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(performedBy());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelatedItemRequest)) {
            return false;
        }
        CreateRelatedItemRequest other = (CreateRelatedItemRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(content(), other.content())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(performedBy(), other.performedBy())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRelatedItemRequest").add("CaseId", caseId()).add("Content", content())
                .add("DomainId", domainId()).add("PerformedBy", performedBy()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "performedBy":
            return Optional.ofNullable(clazz.cast(performedBy()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("performedBy", PERFORMED_BY_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelatedItemRequest, T> g) {
        return obj -> g.apply((CreateRelatedItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRelatedItemRequest> {
        /**
         * <p>
         * A unique identifier of the case.
         * </p>
         * 
         * @param caseId
         *        A unique identifier of the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The content of a related item to be created.
         * </p>
         * 
         * @param content
         *        The content of a related item to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(RelatedItemInputContent content);

        /**
         * <p>
         * The content of a related item to be created.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedItemInputContent.Builder} avoiding
         * the need to create one manually via {@link RelatedItemInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedItemInputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(RelatedItemInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link RelatedItemInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(RelatedItemInputContent)
         */
        default Builder content(Consumer<RelatedItemInputContent.Builder> content) {
            return content(RelatedItemInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Represents the creator of the related item.
         * </p>
         * 
         * @param performedBy
         *        Represents the creator of the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedBy(UserUnion performedBy);

        /**
         * <p>
         * Represents the creator of the related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserUnion.Builder} avoiding the need to
         * create one manually via {@link UserUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #performedBy(UserUnion)}.
         * 
         * @param performedBy
         *        a consumer that will call methods on {@link UserUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performedBy(UserUnion)
         */
        default Builder performedBy(Consumer<UserUnion.Builder> performedBy) {
            return performedBy(UserUnion.builder().applyMutation(performedBy).build());
        }

        /**
         * <p>
         * The type of a related item.
         * </p>
         * 
         * @param type
         *        The type of a related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of a related item.
         * </p>
         * 
         * @param type
         *        The type of a related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder type(RelatedItemType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String caseId;

        private RelatedItemInputContent content;

        private String domainId;

        private UserUnion performedBy;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelatedItemRequest model) {
            super(model);
            caseId(model.caseId);
            content(model.content);
            domainId(model.domainId);
            performedBy(model.performedBy);
            type(model.type);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final RelatedItemInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(RelatedItemInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RelatedItemInputContent content) {
            this.content = content;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserUnion.Builder getPerformedBy() {
            return performedBy != null ? performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(UserUnion.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(UserUnion performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelatedItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelatedItemRequest build() {
            return new CreateRelatedItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
