/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for field Options information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldOption implements SdkPojo, Serializable, ToCopyableBuilder<FieldOption.Builder, FieldOption> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(FieldOption::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FieldOption::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(FieldOption::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD, NAME_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private final String name;

    private final String value;

    private FieldOption(BuilderImpl builder) {
        this.active = builder.active;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * Describes whether the <code>FieldOption</code> is active (displayed) or inactive.
     * </p>
     * 
     * @return Describes whether the <code>FieldOption</code> is active (displayed) or inactive.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * <code>FieldOptionName</code> has max length 100 and disallows trailing spaces.
     * </p>
     * 
     * @return <code>FieldOptionName</code> has max length 100 and disallows trailing spaces.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * <code>FieldOptionValue</code> has max length 100 and must be alphanumeric with hyphens and underscores.
     * </p>
     * 
     * @return <code>FieldOptionValue</code> has max length 100 and must be alphanumeric with hyphens and underscores.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldOption)) {
            return false;
        }
        FieldOption other = (FieldOption) obj;
        return Objects.equals(active(), other.active()) && Objects.equals(name(), other.name())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldOption").add("Active", active()).add("Name", name()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("active", ACTIVE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldOption, T> g) {
        return obj -> g.apply((FieldOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldOption> {
        /**
         * <p>
         * Describes whether the <code>FieldOption</code> is active (displayed) or inactive.
         * </p>
         * 
         * @param active
         *        Describes whether the <code>FieldOption</code> is active (displayed) or inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * <code>FieldOptionName</code> has max length 100 and disallows trailing spaces.
         * </p>
         * 
         * @param name
         *        <code>FieldOptionName</code> has max length 100 and disallows trailing spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * <code>FieldOptionValue</code> has max length 100 and must be alphanumeric with hyphens and underscores.
         * </p>
         * 
         * @param value
         *        <code>FieldOptionValue</code> has max length 100 and must be alphanumeric with hyphens and
         *        underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldOption model) {
            active(model.active);
            name(model.name);
            value(model.value);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public FieldOption build() {
            return new FieldOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
