/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a content of an Amazon Connect file object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileContent implements SdkPojo, Serializable, ToCopyableBuilder<FileContent.Builder, FileContent> {
    private static final SdkField<String> FILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileArn").getter(getter(FileContent::fileArn)).setter(setter(Builder::fileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileArn;

    private FileContent(BuilderImpl builder) {
        this.fileArn = builder.fileArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a File in Amazon Connect.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a File in Amazon Connect.
     */
    public final String fileArn() {
        return fileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileContent)) {
            return false;
        }
        FileContent other = (FileContent) obj;
        return Objects.equals(fileArn(), other.fileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileContent").add("FileArn", fileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileArn":
            return Optional.ofNullable(clazz.cast(fileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileArn", FILE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileContent, T> g) {
        return obj -> g.apply((FileContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileContent> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a File in Amazon Connect.
         * </p>
         * 
         * @param fileArn
         *        The Amazon Resource Name (ARN) of a File in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileArn(String fileArn);
    }

    static final class BuilderImpl implements Builder {
        private String fileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FileContent model) {
            fileArn(model.fileArn);
        }

        public final String getFileArn() {
            return fileArn;
        }

        public final void setFileArn(String fileArn) {
            this.fileArn = fileArn;
        }

        @Override
        public final Builder fileArn(String fileArn) {
            this.fileArn = fileArn;
            return this;
        }

        @Override
        public FileContent build() {
            return new FileContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
