/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object to store detailed field information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFieldResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<GetFieldResponse.Builder, GetFieldResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(GetFieldResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleted").getter(getter(GetFieldResponse::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetFieldResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FIELD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldArn").getter(getter(GetFieldResponse::fieldArn)).setter(setter(Builder::fieldArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldArn").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldId").getter(getter(GetFieldResponse::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetFieldResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetFieldResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetFieldResponse::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetFieldResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetFieldResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            DELETED_FIELD, DESCRIPTION_FIELD, FIELD_ARN_FIELD, FIELD_ID_FIELD, LAST_MODIFIED_TIME_FIELD, NAME_FIELD,
            NAMESPACE_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdTime;

    private final Boolean deleted;

    private final String description;

    private final String fieldArn;

    private final String fieldId;

    private final Instant lastModifiedTime;

    private final String name;

    private final String namespace;

    private final Map<String, String> tags;

    private final String type;

    private GetFieldResponse(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.fieldArn = builder.fieldArn;
        this.fieldId = builder.fieldId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * Timestamp at which the resource was created.
     * </p>
     * 
     * @return Timestamp at which the resource was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Denotes whether or not the resource has been deleted.
     * </p>
     * 
     * @return Denotes whether or not the resource has been deleted.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * Description of the field.
     * </p>
     * 
     * @return Description of the field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the field.
     */
    public final String fieldArn() {
        return fieldArn;
    }

    /**
     * <p>
     * Unique identifier of the field.
     * </p>
     * 
     * @return Unique identifier of the field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * Timestamp at which the resource was created or last modified.
     * </p>
     * 
     * @return Timestamp at which the resource was created or last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Name of the field.
     * </p>
     * 
     * @return Name of the field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Namespace of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link FieldNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return Namespace of the field.
     * @see FieldNamespace
     */
    public final FieldNamespace namespace() {
        return FieldNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * Namespace of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link FieldNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return Namespace of the field.
     * @see FieldNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Type of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the field.
     * @see FieldType
     */
    public final FieldType type() {
        return FieldType.fromValue(type);
    }

    /**
     * <p>
     * Type of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the field.
     * @see FieldType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(fieldArn());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldResponse)) {
            return false;
        }
        GetFieldResponse other = (GetFieldResponse) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(deleted(), other.deleted())
                && Objects.equals(description(), other.description()) && Objects.equals(fieldArn(), other.fieldArn())
                && Objects.equals(fieldId(), other.fieldId()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(name(), other.name()) && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFieldResponse").add("CreatedTime", createdTime()).add("Deleted", deleted())
                .add("Description", description()).add("FieldArn", fieldArn()).add("FieldId", fieldId())
                .add("LastModifiedTime", lastModifiedTime()).add("Name", name()).add("Namespace", namespaceAsString())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "fieldArn":
            return Optional.ofNullable(clazz.cast(fieldArn()));
        case "fieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("fieldArn", FIELD_ARN_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFieldResponse, T> g) {
        return obj -> g.apply((GetFieldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetFieldResponse> {
        /**
         * <p>
         * Timestamp at which the resource was created.
         * </p>
         * 
         * @param createdTime
         *        Timestamp at which the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Denotes whether or not the resource has been deleted.
         * </p>
         * 
         * @param deleted
         *        Denotes whether or not the resource has been deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * Description of the field.
         * </p>
         * 
         * @param description
         *        Description of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the field.
         * </p>
         * 
         * @param fieldArn
         *        The Amazon Resource Name (ARN) of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldArn(String fieldArn);

        /**
         * <p>
         * Unique identifier of the field.
         * </p>
         * 
         * @param fieldId
         *        Unique identifier of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * Timestamp at which the resource was created or last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Timestamp at which the resource was created or last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Name of the field.
         * </p>
         * 
         * @param name
         *        Name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Namespace of the field.
         * </p>
         * 
         * @param namespace
         *        Namespace of the field.
         * @see FieldNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * Namespace of the field.
         * </p>
         * 
         * @param namespace
         *        Namespace of the field.
         * @see FieldNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldNamespace
         */
        Builder namespace(FieldNamespace namespace);

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Type of the field.
         * </p>
         * 
         * @param type
         *        Type of the field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the field.
         * </p>
         * 
         * @param type
         *        Type of the field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder type(FieldType type);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdTime;

        private Boolean deleted;

        private String description;

        private String fieldArn;

        private String fieldId;

        private Instant lastModifiedTime;

        private String name;

        private String namespace;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldResponse model) {
            createdTime(model.createdTime);
            deleted(model.deleted);
            description(model.description);
            fieldArn(model.fieldArn);
            fieldId(model.fieldId);
            lastModifiedTime(model.lastModifiedTime);
            name(model.name);
            namespace(model.namespace);
            tags(model.tags);
            type(model.type);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFieldArn() {
            return fieldArn;
        }

        public final void setFieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
        }

        @Override
        public final Builder fieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(FieldNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetFieldResponse build() {
            return new GetFieldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
