/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutCaseEventConfigurationRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<PutCaseEventConfigurationRequest.Builder, PutCaseEventConfigurationRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(PutCaseEventConfigurationRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<EventBridgeConfiguration> EVENT_BRIDGE_FIELD = SdkField
            .<EventBridgeConfiguration> builder(MarshallingType.SDK_POJO).memberName("eventBridge")
            .getter(getter(PutCaseEventConfigurationRequest::eventBridge)).setter(setter(Builder::eventBridge))
            .constructor(EventBridgeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            EVENT_BRIDGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final EventBridgeConfiguration eventBridge;

    private PutCaseEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.eventBridge = builder.eventBridge;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Configuration to enable EventBridge case event delivery and determine what data is delivered.
     * </p>
     * 
     * @return Configuration to enable EventBridge case event delivery and determine what data is delivered.
     */
    public final EventBridgeConfiguration eventBridge() {
        return eventBridge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCaseEventConfigurationRequest)) {
            return false;
        }
        PutCaseEventConfigurationRequest other = (PutCaseEventConfigurationRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(eventBridge(), other.eventBridge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutCaseEventConfigurationRequest").add("DomainId", domainId()).add("EventBridge", eventBridge())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "eventBridge":
            return Optional.ofNullable(clazz.cast(eventBridge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("eventBridge", EVENT_BRIDGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutCaseEventConfigurationRequest, T> g) {
        return obj -> g.apply((PutCaseEventConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutCaseEventConfigurationRequest> {
        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Configuration to enable EventBridge case event delivery and determine what data is delivered.
         * </p>
         * 
         * @param eventBridge
         *        Configuration to enable EventBridge case event delivery and determine what data is delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridge(EventBridgeConfiguration eventBridge);

        /**
         * <p>
         * Configuration to enable EventBridge case event delivery and determine what data is delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeConfiguration.Builder}
         * avoiding the need to create one manually via {@link EventBridgeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #eventBridge(EventBridgeConfiguration)}.
         * 
         * @param eventBridge
         *        a consumer that will call methods on {@link EventBridgeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridge(EventBridgeConfiguration)
         */
        default Builder eventBridge(Consumer<EventBridgeConfiguration.Builder> eventBridge) {
            return eventBridge(EventBridgeConfiguration.builder().applyMutation(eventBridge).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String domainId;

        private EventBridgeConfiguration eventBridge;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCaseEventConfigurationRequest model) {
            super(model);
            domainId(model.domainId);
            eventBridge(model.eventBridge);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EventBridgeConfiguration.Builder getEventBridge() {
            return eventBridge != null ? eventBridge.toBuilder() : null;
        }

        public final void setEventBridge(EventBridgeConfiguration.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        @Override
        public final Builder eventBridge(EventBridgeConfiguration eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCaseEventConfigurationRequest build() {
            return new PutCaseEventConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
