/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchCasesResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<SearchCasesResponse.Builder, SearchCasesResponse> {
    private static final SdkField<List<SearchCasesResponseItem>> CASES_FIELD = SdkField
            .<List<SearchCasesResponseItem>> builder(MarshallingType.LIST)
            .memberName("cases")
            .getter(getter(SearchCasesResponse::cases))
            .setter(setter(Builder::cases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchCasesResponseItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchCasesResponseItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CASES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SearchCasesResponseItem> cases;

    private final String nextToken;

    private SearchCasesResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cases property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCases() {
        return cases != null && !(cases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of case documents where each case contains the properties <code>CaseId</code> and <code>Fields</code>
     * where each field is a complex union structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCases} method.
     * </p>
     * 
     * @return A list of case documents where each case contains the properties <code>CaseId</code> and
     *         <code>Fields</code> where each field is a complex union structure.
     */
    public final List<SearchCasesResponseItem> cases() {
        return cases;
    }

    /**
     * <p>
     * The token for the next set of results. This is null if there are no more results to return.
     * </p>
     * 
     * @return The token for the next set of results. This is null if there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCases() ? cases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesResponse)) {
            return false;
        }
        SearchCasesResponse other = (SearchCasesResponse) obj;
        return hasCases() == other.hasCases() && Objects.equals(cases(), other.cases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchCasesResponse").add("Cases", hasCases() ? cases() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cases":
            return Optional.ofNullable(clazz.cast(cases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cases", CASES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCasesResponse, T> g) {
        return obj -> g.apply((SearchCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchCasesResponse> {
        /**
         * <p>
         * A list of case documents where each case contains the properties <code>CaseId</code> and <code>Fields</code>
         * where each field is a complex union structure.
         * </p>
         * 
         * @param cases
         *        A list of case documents where each case contains the properties <code>CaseId</code> and
         *        <code>Fields</code> where each field is a complex union structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(Collection<SearchCasesResponseItem> cases);

        /**
         * <p>
         * A list of case documents where each case contains the properties <code>CaseId</code> and <code>Fields</code>
         * where each field is a complex union structure.
         * </p>
         * 
         * @param cases
         *        A list of case documents where each case contains the properties <code>CaseId</code> and
         *        <code>Fields</code> where each field is a complex union structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(SearchCasesResponseItem... cases);

        /**
         * <p>
         * A list of case documents where each case contains the properties <code>CaseId</code> and <code>Fields</code>
         * where each field is a complex union structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem.Builder#build()} is called
         * immediately and its result is passed to {@link #cases(List<SearchCasesResponseItem>)}.
         * 
         * @param cases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cases(java.util.Collection<SearchCasesResponseItem>)
         */
        Builder cases(Consumer<SearchCasesResponseItem.Builder>... cases);

        /**
         * <p>
         * The token for the next set of results. This is null if there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. This is null if there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private List<SearchCasesResponseItem> cases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCasesResponse model) {
            super(model);
            cases(model.cases);
            nextToken(model.nextToken);
        }

        public final List<SearchCasesResponseItem.Builder> getCases() {
            List<SearchCasesResponseItem.Builder> result = SearchCasesResponseCasesListCopier.copyToBuilder(this.cases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCases(Collection<SearchCasesResponseItem.BuilderImpl> cases) {
            this.cases = SearchCasesResponseCasesListCopier.copyFromBuilder(cases);
        }

        @Override
        public final Builder cases(Collection<SearchCasesResponseItem> cases) {
            this.cases = SearchCasesResponseCasesListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(SearchCasesResponseItem... cases) {
            cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<SearchCasesResponseItem.Builder>... cases) {
            cases(Stream.of(cases).map(c -> SearchCasesResponseItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchCasesResponse build() {
            return new SearchCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
