/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of items that represent cases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchCasesResponseItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchCasesResponseItem.Builder, SearchCasesResponseItem> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(SearchCasesResponseItem::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<List<FieldValue>> FIELDS_FIELD = SdkField
            .<List<FieldValue>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(SearchCasesResponseItem::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SearchCasesResponseItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(SearchCasesResponseItem::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, FIELDS_FIELD,
            TAGS_FIELD, TEMPLATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseId;

    private final List<FieldValue> fields;

    private final Map<String, String> tags;

    private final String templateId;

    private SearchCasesResponseItem(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.fields = builder.fields;
        this.tags = builder.tags;
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * A unique identifier of the case.
     * </p>
     * 
     * @return A unique identifier of the case.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of case field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return List of case field values.
     */
    public final List<FieldValue> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier of a template.
     * </p>
     * 
     * @return A unique identifier of a template.
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesResponseItem)) {
            return false;
        }
        SearchCasesResponseItem other = (SearchCasesResponseItem) obj;
        return Objects.equals(caseId(), other.caseId()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchCasesResponseItem").add("CaseId", caseId()).add("Fields", hasFields() ? fields() : null)
                .add("Tags", hasTags() ? tags() : null).add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCasesResponseItem, T> g) {
        return obj -> g.apply((SearchCasesResponseItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchCasesResponseItem> {
        /**
         * <p>
         * A unique identifier of the case.
         * </p>
         * 
         * @param caseId
         *        A unique identifier of the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * List of case field values.
         * </p>
         * 
         * @param fields
         *        List of case field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<FieldValue> fields);

        /**
         * <p>
         * List of case field values.
         * </p>
         * 
         * @param fields
         *        List of case field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(FieldValue... fields);

        /**
         * <p>
         * List of case field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.FieldValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.FieldValue.Builder#build()} is called immediately
         * and its result is passed to {@link #fields(List<FieldValue>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<FieldValue>)
         */
        Builder fields(Consumer<FieldValue.Builder>... fields);

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique identifier of a template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier of a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private List<FieldValue> fields = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCasesResponseItem model) {
            caseId(model.caseId);
            fields(model.fields);
            tags(model.tags);
            templateId(model.templateId);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final List<FieldValue.Builder> getFields() {
            List<FieldValue.Builder> result = SearchCasesResponseItemFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FieldValue.BuilderImpl> fields) {
            this.fields = SearchCasesResponseItemFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FieldValue> fields) {
            this.fields = SearchCasesResponseItemFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FieldValue... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FieldValue.Builder>... fields) {
            fields(Stream.of(fields).map(c -> FieldValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public SearchCasesResponseItem build() {
            return new SearchCasesResponseItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
