/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Boolean condition for a rule. In the Amazon Connect admin website, case rules are known as <i>case field
 * conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<BooleanCondition.Builder, BooleanCondition> {
    private static final SdkField<BooleanOperands> EQUAL_TO_FIELD = SdkField.<BooleanOperands> builder(MarshallingType.SDK_POJO)
            .memberName("equalTo").getter(getter(BooleanCondition::equalTo)).setter(setter(Builder::equalTo))
            .constructor(BooleanOperands::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalTo").build()).build();

    private static final SdkField<BooleanOperands> NOT_EQUAL_TO_FIELD = SdkField
            .<BooleanOperands> builder(MarshallingType.SDK_POJO).memberName("notEqualTo")
            .getter(getter(BooleanCondition::notEqualTo)).setter(setter(Builder::notEqualTo))
            .constructor(BooleanOperands::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEqualTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUAL_TO_FIELD,
            NOT_EQUAL_TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BooleanOperands equalTo;

    private final BooleanOperands notEqualTo;

    private final Type type;

    private BooleanCondition(BuilderImpl builder) {
        this.equalTo = builder.equalTo;
        this.notEqualTo = builder.notEqualTo;
        this.type = builder.type;
    }

    /**
     * <p>
     * Tests that operandOne is equal to operandTwo.
     * </p>
     * 
     * @return Tests that operandOne is equal to operandTwo.
     */
    public final BooleanOperands equalTo() {
        return equalTo;
    }

    /**
     * <p>
     * Tests that operandOne is not equal to operandTwo.
     * </p>
     * 
     * @return Tests that operandOne is not equal to operandTwo.
     */
    public final BooleanOperands notEqualTo() {
        return notEqualTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(equalTo());
        hashCode = 31 * hashCode + Objects.hashCode(notEqualTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanCondition)) {
            return false;
        }
        BooleanCondition other = (BooleanCondition) obj;
        return Objects.equals(equalTo(), other.equalTo()) && Objects.equals(notEqualTo(), other.notEqualTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BooleanCondition").add("EqualTo", equalTo()).add("NotEqualTo", notEqualTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "equalTo":
            return Optional.ofNullable(clazz.cast(equalTo()));
        case "notEqualTo":
            return Optional.ofNullable(clazz.cast(notEqualTo()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * Tests that operandOne is equal to operandTwo.
     * </p>
     * 
     * @param equalTo
     *        Tests that operandOne is equal to operandTwo.
     */
    public static BooleanCondition fromEqualTo(BooleanOperands equalTo) {
        return builder().equalTo(equalTo).build();
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * Tests that operandOne is equal to operandTwo.
     * </p>
     * 
     * @param equalTo
     *        Tests that operandOne is equal to operandTwo.
     */
    public static BooleanCondition fromEqualTo(Consumer<BooleanOperands.Builder> equalTo) {
        BooleanOperands.Builder builder = BooleanOperands.builder();
        equalTo.accept(builder);
        return fromEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notEqualTo()} initialized to the given value.
     *
     * <p>
     * Tests that operandOne is not equal to operandTwo.
     * </p>
     * 
     * @param notEqualTo
     *        Tests that operandOne is not equal to operandTwo.
     */
    public static BooleanCondition fromNotEqualTo(BooleanOperands notEqualTo) {
        return builder().notEqualTo(notEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #notEqualTo()} initialized to the given value.
     *
     * <p>
     * Tests that operandOne is not equal to operandTwo.
     * </p>
     * 
     * @param notEqualTo
     *        Tests that operandOne is not equal to operandTwo.
     */
    public static BooleanCondition fromNotEqualTo(Consumer<BooleanOperands.Builder> notEqualTo) {
        BooleanOperands.Builder builder = BooleanOperands.builder();
        notEqualTo.accept(builder);
        return fromNotEqualTo(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equalTo", EQUAL_TO_FIELD);
        map.put("notEqualTo", NOT_EQUAL_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BooleanCondition, T> g) {
        return obj -> g.apply((BooleanCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanCondition> {
        /**
         * <p>
         * Tests that operandOne is equal to operandTwo.
         * </p>
         * 
         * @param equalTo
         *        Tests that operandOne is equal to operandTwo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalTo(BooleanOperands equalTo);

        /**
         * <p>
         * Tests that operandOne is equal to operandTwo.
         * </p>
         * This is a convenience method that creates an instance of the {@link BooleanOperands.Builder} avoiding the
         * need to create one manually via {@link BooleanOperands#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BooleanOperands.Builder#build()} is called immediately and its
         * result is passed to {@link #equalTo(BooleanOperands)}.
         * 
         * @param equalTo
         *        a consumer that will call methods on {@link BooleanOperands.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalTo(BooleanOperands)
         */
        default Builder equalTo(Consumer<BooleanOperands.Builder> equalTo) {
            return equalTo(BooleanOperands.builder().applyMutation(equalTo).build());
        }

        /**
         * <p>
         * Tests that operandOne is not equal to operandTwo.
         * </p>
         * 
         * @param notEqualTo
         *        Tests that operandOne is not equal to operandTwo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEqualTo(BooleanOperands notEqualTo);

        /**
         * <p>
         * Tests that operandOne is not equal to operandTwo.
         * </p>
         * This is a convenience method that creates an instance of the {@link BooleanOperands.Builder} avoiding the
         * need to create one manually via {@link BooleanOperands#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BooleanOperands.Builder#build()} is called immediately and its
         * result is passed to {@link #notEqualTo(BooleanOperands)}.
         * 
         * @param notEqualTo
         *        a consumer that will call methods on {@link BooleanOperands.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notEqualTo(BooleanOperands)
         */
        default Builder notEqualTo(Consumer<BooleanOperands.Builder> notEqualTo) {
            return notEqualTo(BooleanOperands.builder().applyMutation(notEqualTo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BooleanOperands equalTo;

        private BooleanOperands notEqualTo;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanCondition model) {
            equalTo(model.equalTo);
            notEqualTo(model.notEqualTo);
        }

        public final BooleanOperands.Builder getEqualTo() {
            return equalTo != null ? equalTo.toBuilder() : null;
        }

        public final void setEqualTo(BooleanOperands.BuilderImpl equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo != null ? equalTo.build() : null;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
        }

        @Override
        public final Builder equalTo(BooleanOperands equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
            return this;
        }

        public final BooleanOperands.Builder getNotEqualTo() {
            return notEqualTo != null ? notEqualTo.toBuilder() : null;
        }

        public final void setNotEqualTo(BooleanOperands.BuilderImpl notEqualTo) {
            Object oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo != null ? notEqualTo.build() : null;
            handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
        }

        @Override
        public final Builder notEqualTo(BooleanOperands notEqualTo) {
            Object oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo;
            handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
            return this;
        }

        @Override
        public BooleanCondition build() {
            return new BooleanCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see BooleanCondition#type()
     */
    public enum Type {
        EQUAL_TO,

        NOT_EQUAL_TO,

        UNKNOWN_TO_SDK_VERSION
    }
}
