/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for related items of type <code>Contact</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFilter implements SdkPojo, Serializable, ToCopyableBuilder<ContactFilter.Builder, ContactFilter> {
    private static final SdkField<List<String>> CHANNEL_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("channel")
            .getter(getter(ContactFilter::channel))
            .setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactArn").getter(getter(ContactFilter::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            CONTACT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> channel;

    private final String contactArn;

    private ContactFilter(BuilderImpl builder) {
        this.channel = builder.channel;
        this.contactArn = builder.contactArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channel property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannel() {
        return channel != null && !(channel instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of channels to filter on for related items of type <code>Contact</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannel} method.
     * </p>
     * 
     * @return A list of channels to filter on for related items of type <code>Contact</code>.
     */
    public final List<String> channel() {
        return channel;
    }

    /**
     * <p>
     * A unique identifier of a contact in Amazon Connect.
     * </p>
     * 
     * @return A unique identifier of a contact in Amazon Connect.
     */
    public final String contactArn() {
        return contactArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChannel() ? channel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFilter)) {
            return false;
        }
        ContactFilter other = (ContactFilter) obj;
        return hasChannel() == other.hasChannel() && Objects.equals(channel(), other.channel())
                && Objects.equals(contactArn(), other.contactArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFilter").add("Channel", hasChannel() ? channel() : null).add("ContactArn", contactArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "contactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channel", CHANNEL_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFilter, T> g) {
        return obj -> g.apply((ContactFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFilter> {
        /**
         * <p>
         * A list of channels to filter on for related items of type <code>Contact</code>.
         * </p>
         * 
         * @param channel
         *        A list of channels to filter on for related items of type <code>Contact</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(Collection<String> channel);

        /**
         * <p>
         * A list of channels to filter on for related items of type <code>Contact</code>.
         * </p>
         * 
         * @param channel
         *        A list of channels to filter on for related items of type <code>Contact</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String... channel);

        /**
         * <p>
         * A unique identifier of a contact in Amazon Connect.
         * </p>
         * 
         * @param contactArn
         *        A unique identifier of a contact in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> channel = DefaultSdkAutoConstructList.getInstance();

        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFilter model) {
            channel(model.channel);
            contactArn(model.contactArn);
        }

        public final Collection<String> getChannel() {
            if (channel instanceof SdkAutoConstructList) {
                return null;
            }
            return channel;
        }

        public final void setChannel(Collection<String> channel) {
            this.channel = ContactFilterChannelListCopier.copy(channel);
        }

        @Override
        public final Builder channel(Collection<String> channel) {
            this.channel = ContactFilterChannelListCopier.copy(channel);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channel(String... channel) {
            channel(Arrays.asList(channel));
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        @Override
        public ContactFilter build() {
            return new ContactFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
