/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for fields in <code>Custom</code> type related items. Only one value can be provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFieldsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomFieldsFilter.Builder, CustomFieldsFilter> {
    private static final SdkField<FieldFilter> FIELD_FIELD = SdkField.<FieldFilter> builder(MarshallingType.SDK_POJO)
            .memberName("field").getter(getter(CustomFieldsFilter::field)).setter(setter(Builder::field))
            .constructor(FieldFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<CustomFieldsFilter> NOT_FIELD = SdkField.<CustomFieldsFilter> builder(MarshallingType.SDK_POJO)
            .memberName("not").getter(getter(CustomFieldsFilter::not)).setter(setter(Builder::not))
            .constructor(CustomFieldsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("not").build()).build();

    private static final SdkField<List<CustomFieldsFilter>> AND_ALL_FIELD = SdkField
            .<List<CustomFieldsFilter>> builder(MarshallingType.LIST)
            .memberName("andAll")
            .getter(getter(CustomFieldsFilter::andAll))
            .setter(setter(Builder::andAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomFieldsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomFieldsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomFieldsFilter>> OR_ALL_FIELD = SdkField
            .<List<CustomFieldsFilter>> builder(MarshallingType.LIST)
            .memberName("orAll")
            .getter(getter(CustomFieldsFilter::orAll))
            .setter(setter(Builder::orAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomFieldsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomFieldsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, NOT_FIELD,
            AND_ALL_FIELD, OR_ALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldFilter field;

    private final CustomFieldsFilter not;

    private final List<CustomFieldsFilter> andAll;

    private final List<CustomFieldsFilter> orAll;

    private final Type type;

    private CustomFieldsFilter(BuilderImpl builder) {
        this.field = builder.field;
        this.not = builder.not;
        this.andAll = builder.andAll;
        this.orAll = builder.orAll;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Field property for this object.
     * 
     * @return The value of the Field property for this object.
     */
    public final FieldFilter field() {
        return field;
    }

    /**
     * <p>
     * Excludes items matching the filter.
     * </p>
     * 
     * @return Excludes items matching the filter.
     */
    public final CustomFieldsFilter not() {
        return not;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAll property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAndAll() {
        return andAll != null && !(andAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides "and all" filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAll} method.
     * </p>
     * 
     * @return Provides "and all" filtering.
     */
    public final List<CustomFieldsFilter> andAll() {
        return andAll;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAll property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrAll() {
        return orAll != null && !(orAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides "or all" filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAll} method.
     * </p>
     * 
     * @return Provides "or all" filtering.
     */
    public final List<CustomFieldsFilter> orAll() {
        return orAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(not());
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAll() ? andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAll() ? orAll() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFieldsFilter)) {
            return false;
        }
        CustomFieldsFilter other = (CustomFieldsFilter) obj;
        return Objects.equals(field(), other.field()) && Objects.equals(not(), other.not()) && hasAndAll() == other.hasAndAll()
                && Objects.equals(andAll(), other.andAll()) && hasOrAll() == other.hasOrAll()
                && Objects.equals(orAll(), other.orAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFieldsFilter").add("Field", field()).add("Not", not())
                .add("AndAll", hasAndAll() ? andAll() : null).add("OrAll", hasOrAll() ? orAll() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        case "not":
            return Optional.ofNullable(clazz.cast(not()));
        case "andAll":
            return Optional.ofNullable(clazz.cast(andAll()));
        case "orAll":
            return Optional.ofNullable(clazz.cast(orAll()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #field()} initialized to the given value.
     *
     * Sets the value of the Field property for this object.
     *
     * @param field
     *        The new value for the Field property for this object.
     */
    public static CustomFieldsFilter fromField(FieldFilter field) {
        return builder().field(field).build();
    }

    /**
     * Create an instance of this class with {@link #field()} initialized to the given value.
     *
     * Sets the value of the Field property for this object.
     *
     * @param field
     *        The new value for the Field property for this object.
     */
    public static CustomFieldsFilter fromField(Consumer<FieldFilter.Builder> field) {
        FieldFilter.Builder builder = FieldFilter.builder();
        field.accept(builder);
        return fromField(builder.build());
    }

    /**
     * Create an instance of this class with {@link #not()} initialized to the given value.
     *
     * <p>
     * Excludes items matching the filter.
     * </p>
     * 
     * @param not
     *        Excludes items matching the filter.
     */
    public static CustomFieldsFilter fromNot(CustomFieldsFilter not) {
        return builder().not(not).build();
    }

    /**
     * Create an instance of this class with {@link #not()} initialized to the given value.
     *
     * <p>
     * Excludes items matching the filter.
     * </p>
     * 
     * @param not
     *        Excludes items matching the filter.
     */
    public static CustomFieldsFilter fromNot(Consumer<Builder> not) {
        Builder builder = CustomFieldsFilter.builder();
        not.accept(builder);
        return fromNot(builder.build());
    }

    /**
     * Create an instance of this class with {@link #andAll()} initialized to the given value.
     *
     * <p>
     * Provides "and all" filtering.
     * </p>
     * 
     * @param andAll
     *        Provides "and all" filtering.
     */
    public static CustomFieldsFilter fromAndAll(List<CustomFieldsFilter> andAll) {
        return builder().andAll(andAll).build();
    }

    /**
     * Create an instance of this class with {@link #orAll()} initialized to the given value.
     *
     * <p>
     * Provides "or all" filtering.
     * </p>
     * 
     * @param orAll
     *        Provides "or all" filtering.
     */
    public static CustomFieldsFilter fromOrAll(List<CustomFieldsFilter> orAll) {
        return builder().orAll(orAll).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("field", FIELD_FIELD);
        map.put("not", NOT_FIELD);
        map.put("andAll", AND_ALL_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFieldsFilter, T> g) {
        return obj -> g.apply((CustomFieldsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFieldsFilter> {
        /**
         * Sets the value of the Field property for this object.
         *
         * @param field
         *        The new value for the Field property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(FieldFilter field);

        /**
         * Sets the value of the Field property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FieldFilter.Builder} avoiding the need to
         * create one manually via {@link FieldFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #field(FieldFilter)}.
         * 
         * @param field
         *        a consumer that will call methods on {@link FieldFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #field(FieldFilter)
         */
        default Builder field(Consumer<FieldFilter.Builder> field) {
            return field(FieldFilter.builder().applyMutation(field).build());
        }

        /**
         * <p>
         * Excludes items matching the filter.
         * </p>
         * 
         * @param not
         *        Excludes items matching the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder not(CustomFieldsFilter not);

        /**
         * <p>
         * Excludes items matching the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomFieldsFilter.Builder} avoiding the
         * need to create one manually via {@link CustomFieldsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomFieldsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #not(CustomFieldsFilter)}.
         * 
         * @param not
         *        a consumer that will call methods on {@link CustomFieldsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #not(CustomFieldsFilter)
         */
        default Builder not(Consumer<Builder> not) {
            return not(CustomFieldsFilter.builder().applyMutation(not).build());
        }

        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * 
         * @param andAll
         *        Provides "and all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(Collection<CustomFieldsFilter> andAll);

        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * 
         * @param andAll
         *        Provides "and all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(CustomFieldsFilter... andAll);

        /**
         * <p>
         * Provides "and all" filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #andAll(List<CustomFieldsFilter>)}.
         * 
         * @param andAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAll(java.util.Collection<CustomFieldsFilter>)
         */
        Builder andAll(Consumer<Builder>... andAll);

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * 
         * @param orAll
         *        Provides "or all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(Collection<CustomFieldsFilter> orAll);

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * 
         * @param orAll
         *        Provides "or all" filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(CustomFieldsFilter... orAll);

        /**
         * <p>
         * Provides "or all" filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #orAll(List<CustomFieldsFilter>)}.
         * 
         * @param orAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CustomFieldsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAll(java.util.Collection<CustomFieldsFilter>)
         */
        Builder orAll(Consumer<Builder>... orAll);
    }

    static final class BuilderImpl implements Builder {
        private FieldFilter field;

        private CustomFieldsFilter not;

        private List<CustomFieldsFilter> andAll = DefaultSdkAutoConstructList.getInstance();

        private List<CustomFieldsFilter> orAll = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFieldsFilter model) {
            field(model.field);
            not(model.not);
            andAll(model.andAll);
            orAll(model.orAll);
        }

        public final FieldFilter.Builder getField() {
            return field != null ? field.toBuilder() : null;
        }

        public final void setField(FieldFilter.BuilderImpl field) {
            Object oldValue = this.field;
            this.field = field != null ? field.build() : null;
            handleUnionValueChange(Type.FIELD, oldValue, this.field);
        }

        @Override
        public final Builder field(FieldFilter field) {
            Object oldValue = this.field;
            this.field = field;
            handleUnionValueChange(Type.FIELD, oldValue, this.field);
            return this;
        }

        public final Builder getNot() {
            return not != null ? not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            Object oldValue = this.not;
            this.not = not != null ? not.build() : null;
            handleUnionValueChange(Type.NOT, oldValue, this.not);
        }

        @Override
        public final Builder not(CustomFieldsFilter not) {
            Object oldValue = this.not;
            this.not = not;
            handleUnionValueChange(Type.NOT, oldValue, this.not);
            return this;
        }

        public final List<Builder> getAndAll() {
            List<Builder> result = CustomFieldsFilterAndAllListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<BuilderImpl> andAll) {
            Object oldValue = this.andAll;
            this.andAll = CustomFieldsFilterAndAllListCopier.copyFromBuilder(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<CustomFieldsFilter> andAll) {
            Object oldValue = this.andAll;
            this.andAll = CustomFieldsFilterAndAllListCopier.copy(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(CustomFieldsFilter... andAll) {
            andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<Builder>... andAll) {
            andAll(Stream.of(andAll).map(c -> CustomFieldsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOrAll() {
            List<Builder> result = CustomFieldsFilterOrAllListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<BuilderImpl> orAll) {
            Object oldValue = this.orAll;
            this.orAll = CustomFieldsFilterOrAllListCopier.copyFromBuilder(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<CustomFieldsFilter> orAll) {
            Object oldValue = this.orAll;
            this.orAll = CustomFieldsFilterOrAllListCopier.copy(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(CustomFieldsFilter... orAll) {
            orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<Builder>... orAll) {
            orAll(Stream.of(orAll).map(c -> CustomFieldsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomFieldsFilter build() {
            return new CustomFieldsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomFieldsFilter#type()
     */
    public enum Type {
        FIELD,

        NOT,

        AND_ALL,

        OR_ALL,

        UNKNOWN_TO_SDK_VERSION
    }
}
