/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for related items of type <code>Custom</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFilter implements SdkPojo, Serializable, ToCopyableBuilder<CustomFilter.Builder, CustomFilter> {
    private static final SdkField<CustomFieldsFilter> FIELDS_FIELD = SdkField
            .<CustomFieldsFilter> builder(MarshallingType.SDK_POJO).memberName("fields").getter(getter(CustomFilter::fields))
            .setter(setter(Builder::fields)).constructor(CustomFieldsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomFieldsFilter fields;

    private CustomFilter(BuilderImpl builder) {
        this.fields = builder.fields;
    }

    /**
     * <p>
     * Filter conditions for custom fields.
     * </p>
     * 
     * @return Filter conditions for custom fields.
     */
    public final CustomFieldsFilter fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFilter)) {
            return false;
        }
        CustomFilter other = (CustomFilter) obj;
        return Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFilter").add("Fields", fields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFilter, T> g) {
        return obj -> g.apply((CustomFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFilter> {
        /**
         * <p>
         * Filter conditions for custom fields.
         * </p>
         * 
         * @param fields
         *        Filter conditions for custom fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(CustomFieldsFilter fields);

        /**
         * <p>
         * Filter conditions for custom fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomFieldsFilter.Builder} avoiding the
         * need to create one manually via {@link CustomFieldsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomFieldsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #fields(CustomFieldsFilter)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link CustomFieldsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(CustomFieldsFilter)
         */
        default Builder fields(Consumer<CustomFieldsFilter.Builder> fields) {
            return fields(CustomFieldsFilter.builder().applyMutation(fields).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomFieldsFilter fields;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFilter model) {
            fields(model.fields);
        }

        public final CustomFieldsFilter.Builder getFields() {
            return fields != null ? fields.toBuilder() : null;
        }

        public final void setFields(CustomFieldsFilter.BuilderImpl fields) {
            this.fields = fields != null ? fields.build() : null;
        }

        @Override
        public final Builder fields(CustomFieldsFilter fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public CustomFilter build() {
            return new CustomFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
