/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule that controls field visibility based on conditions. Fields can be shown or hidden dynamically based on values
 * in other fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HiddenCaseRule implements SdkPojo, Serializable, ToCopyableBuilder<HiddenCaseRule.Builder, HiddenCaseRule> {
    private static final SdkField<Boolean> DEFAULT_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultValue").getter(getter(HiddenCaseRule::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<List<BooleanCondition>> CONDITIONS_FIELD = SdkField
            .<List<BooleanCondition>> builder(MarshallingType.LIST)
            .memberName("conditions")
            .getter(getter(HiddenCaseRule::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BooleanCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(BooleanCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean defaultValue;

    private final List<BooleanCondition> conditions;

    private HiddenCaseRule(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * Whether the field is hidden when no conditions match.
     * </p>
     * 
     * @return Whether the field is hidden when no conditions match.
     */
    public final Boolean defaultValue() {
        return defaultValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions that determine field visibility.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return A list of conditions that determine field visibility.
     */
    public final List<BooleanCondition> conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiddenCaseRule)) {
            return false;
        }
        HiddenCaseRule other = (HiddenCaseRule) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && hasConditions() == other.hasConditions()
                && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HiddenCaseRule").add("DefaultValue", defaultValue())
                .add("Conditions", hasConditions() ? conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HiddenCaseRule, T> g) {
        return obj -> g.apply((HiddenCaseRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HiddenCaseRule> {
        /**
         * <p>
         * Whether the field is hidden when no conditions match.
         * </p>
         * 
         * @param defaultValue
         *        Whether the field is hidden when no conditions match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Boolean defaultValue);

        /**
         * <p>
         * A list of conditions that determine field visibility.
         * </p>
         * 
         * @param conditions
         *        A list of conditions that determine field visibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<BooleanCondition> conditions);

        /**
         * <p>
         * A list of conditions that determine field visibility.
         * </p>
         * 
         * @param conditions
         *        A list of conditions that determine field visibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(BooleanCondition... conditions);

        /**
         * <p>
         * A list of conditions that determine field visibility.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.BooleanCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcases.model.BooleanCondition#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.BooleanCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<BooleanCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.BooleanCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<BooleanCondition>)
         */
        Builder conditions(Consumer<BooleanCondition.Builder>... conditions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean defaultValue;

        private List<BooleanCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiddenCaseRule model) {
            defaultValue(model.defaultValue);
            conditions(model.conditions);
        }

        public final Boolean getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final List<BooleanCondition.Builder> getConditions() {
            List<BooleanCondition.Builder> result = BooleanConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<BooleanCondition.BuilderImpl> conditions) {
            this.conditions = BooleanConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<BooleanCondition> conditions) {
            this.conditions = BooleanConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(BooleanCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<BooleanCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> BooleanCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public HiddenCaseRule build() {
            return new HiddenCaseRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
