/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the content of a particular type of related item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItemContent implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedItemContent.Builder, RelatedItemContent> {
    private static final SdkField<ContactContent> CONTACT_FIELD = SdkField.<ContactContent> builder(MarshallingType.SDK_POJO)
            .memberName("contact").getter(getter(RelatedItemContent::contact)).setter(setter(Builder::contact))
            .constructor(ContactContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()).build();

    private static final SdkField<CommentContent> COMMENT_FIELD = SdkField.<CommentContent> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(RelatedItemContent::comment)).setter(setter(Builder::comment))
            .constructor(CommentContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<FileContent> FILE_FIELD = SdkField.<FileContent> builder(MarshallingType.SDK_POJO)
            .memberName("file").getter(getter(RelatedItemContent::file)).setter(setter(Builder::file))
            .constructor(FileContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<SlaContent> SLA_FIELD = SdkField.<SlaContent> builder(MarshallingType.SDK_POJO)
            .memberName("sla").getter(getter(RelatedItemContent::sla)).setter(setter(Builder::sla))
            .constructor(SlaContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sla").build()).build();

    private static final SdkField<ConnectCaseContent> CONNECT_CASE_FIELD = SdkField
            .<ConnectCaseContent> builder(MarshallingType.SDK_POJO).memberName("connectCase")
            .getter(getter(RelatedItemContent::connectCase)).setter(setter(Builder::connectCase))
            .constructor(ConnectCaseContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCase").build()).build();

    private static final SdkField<CustomContent> CUSTOM_FIELD = SdkField.<CustomContent> builder(MarshallingType.SDK_POJO)
            .memberName("custom").getter(getter(RelatedItemContent::custom)).setter(setter(Builder::custom))
            .constructor(CustomContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FIELD, COMMENT_FIELD,
            FILE_FIELD, SLA_FIELD, CONNECT_CASE_FIELD, CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContactContent contact;

    private final CommentContent comment;

    private final FileContent file;

    private final SlaContent sla;

    private final ConnectCaseContent connectCase;

    private final CustomContent custom;

    private final Type type;

    private RelatedItemContent(BuilderImpl builder) {
        this.contact = builder.contact;
        this.comment = builder.comment;
        this.file = builder.file;
        this.sla = builder.sla;
        this.connectCase = builder.connectCase;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    /**
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @return Represents the content of a contact to be returned to agents.
     */
    public final ContactContent contact() {
        return contact;
    }

    /**
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @return Represents the content of a comment to be returned to agents.
     */
    public final CommentContent comment() {
        return comment;
    }

    /**
     * <p>
     * Represents the content of a File to be returned to agents.
     * </p>
     * 
     * @return Represents the content of a File to be returned to agents.
     */
    public final FileContent file() {
        return file;
    }

    /**
     * <p>
     * Represents the content of an SLA to be returned to agents.
     * </p>
     * 
     * @return Represents the content of an SLA to be returned to agents.
     */
    public final SlaContent sla() {
        return sla;
    }

    /**
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @return Represents the Amazon Connect case to be created as a related item.
     */
    public final ConnectCaseContent connectCase() {
        return connectCase;
    }

    /**
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @return Represents the content of a <code>Custom</code> type related item.
     */
    public final CustomContent custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contact());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sla());
        hashCode = 31 * hashCode + Objects.hashCode(connectCase());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemContent)) {
            return false;
        }
        RelatedItemContent other = (RelatedItemContent) obj;
        return Objects.equals(contact(), other.contact()) && Objects.equals(comment(), other.comment())
                && Objects.equals(file(), other.file()) && Objects.equals(sla(), other.sla())
                && Objects.equals(connectCase(), other.connectCase()) && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItemContent").add("Contact", contact()).add("Comment", comment()).add("File", file())
                .add("Sla", sla()).add("ConnectCase", connectCase()).add("Custom", custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contact":
            return Optional.ofNullable(clazz.cast(contact()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sla":
            return Optional.ofNullable(clazz.cast(sla()));
        case "connectCase":
            return Optional.ofNullable(clazz.cast(connectCase()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @param contact
     *        Represents the content of a contact to be returned to agents.
     */
    public static RelatedItemContent fromContact(ContactContent contact) {
        return builder().contact(contact).build();
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * Represents the content of a contact to be returned to agents.
     * </p>
     * 
     * @param contact
     *        Represents the content of a contact to be returned to agents.
     */
    public static RelatedItemContent fromContact(Consumer<ContactContent.Builder> contact) {
        ContactContent.Builder builder = ContactContent.builder();
        contact.accept(builder);
        return fromContact(builder.build());
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @param comment
     *        Represents the content of a comment to be returned to agents.
     */
    public static RelatedItemContent fromComment(CommentContent comment) {
        return builder().comment(comment).build();
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * Represents the content of a comment to be returned to agents.
     * </p>
     * 
     * @param comment
     *        Represents the content of a comment to be returned to agents.
     */
    public static RelatedItemContent fromComment(Consumer<CommentContent.Builder> comment) {
        CommentContent.Builder builder = CommentContent.builder();
        comment.accept(builder);
        return fromComment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * Represents the content of a File to be returned to agents.
     * </p>
     * 
     * @param file
     *        Represents the content of a File to be returned to agents.
     */
    public static RelatedItemContent fromFile(FileContent file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * Represents the content of a File to be returned to agents.
     * </p>
     * 
     * @param file
     *        Represents the content of a File to be returned to agents.
     */
    public static RelatedItemContent fromFile(Consumer<FileContent.Builder> file) {
        FileContent.Builder builder = FileContent.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sla()} initialized to the given value.
     *
     * <p>
     * Represents the content of an SLA to be returned to agents.
     * </p>
     * 
     * @param sla
     *        Represents the content of an SLA to be returned to agents.
     */
    public static RelatedItemContent fromSla(SlaContent sla) {
        return builder().sla(sla).build();
    }

    /**
     * Create an instance of this class with {@link #sla()} initialized to the given value.
     *
     * <p>
     * Represents the content of an SLA to be returned to agents.
     * </p>
     * 
     * @param sla
     *        Represents the content of an SLA to be returned to agents.
     */
    public static RelatedItemContent fromSla(Consumer<SlaContent.Builder> sla) {
        SlaContent.Builder builder = SlaContent.builder();
        sla.accept(builder);
        return fromSla(builder.build());
    }

    /**
     * Create an instance of this class with {@link #connectCase()} initialized to the given value.
     *
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @param connectCase
     *        Represents the Amazon Connect case to be created as a related item.
     */
    public static RelatedItemContent fromConnectCase(ConnectCaseContent connectCase) {
        return builder().connectCase(connectCase).build();
    }

    /**
     * Create an instance of this class with {@link #connectCase()} initialized to the given value.
     *
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @param connectCase
     *        Represents the Amazon Connect case to be created as a related item.
     */
    public static RelatedItemContent fromConnectCase(Consumer<ConnectCaseContent.Builder> connectCase) {
        ConnectCaseContent.Builder builder = ConnectCaseContent.builder();
        connectCase.accept(builder);
        return fromConnectCase(builder.build());
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @param custom
     *        Represents the content of a <code>Custom</code> type related item.
     */
    public static RelatedItemContent fromCustom(CustomContent custom) {
        return builder().custom(custom).build();
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @param custom
     *        Represents the content of a <code>Custom</code> type related item.
     */
    public static RelatedItemContent fromCustom(Consumer<CustomContent.Builder> custom) {
        CustomContent.Builder builder = CustomContent.builder();
        custom.accept(builder);
        return fromCustom(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contact", CONTACT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sla", SLA_FIELD);
        map.put("connectCase", CONNECT_CASE_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemContent, T> g) {
        return obj -> g.apply((RelatedItemContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItemContent> {
        /**
         * <p>
         * Represents the content of a contact to be returned to agents.
         * </p>
         * 
         * @param contact
         *        Represents the content of a contact to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contact(ContactContent contact);

        /**
         * <p>
         * Represents the content of a contact to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactContent.Builder} avoiding the need
         * to create one manually via {@link ContactContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactContent.Builder#build()} is called immediately and its
         * result is passed to {@link #contact(ContactContent)}.
         * 
         * @param contact
         *        a consumer that will call methods on {@link ContactContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contact(ContactContent)
         */
        default Builder contact(Consumer<ContactContent.Builder> contact) {
            return contact(ContactContent.builder().applyMutation(contact).build());
        }

        /**
         * <p>
         * Represents the content of a comment to be returned to agents.
         * </p>
         * 
         * @param comment
         *        Represents the content of a comment to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(CommentContent comment);

        /**
         * <p>
         * Represents the content of a comment to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommentContent.Builder} avoiding the need
         * to create one manually via {@link CommentContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommentContent.Builder#build()} is called immediately and its
         * result is passed to {@link #comment(CommentContent)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link CommentContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(CommentContent)
         */
        default Builder comment(Consumer<CommentContent.Builder> comment) {
            return comment(CommentContent.builder().applyMutation(comment).build());
        }

        /**
         * <p>
         * Represents the content of a File to be returned to agents.
         * </p>
         * 
         * @param file
         *        Represents the content of a File to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(FileContent file);

        /**
         * <p>
         * Represents the content of a File to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileContent.Builder} avoiding the need to
         * create one manually via {@link FileContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileContent.Builder#build()} is called immediately and its result
         * is passed to {@link #file(FileContent)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link FileContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(FileContent)
         */
        default Builder file(Consumer<FileContent.Builder> file) {
            return file(FileContent.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * Represents the content of an SLA to be returned to agents.
         * </p>
         * 
         * @param sla
         *        Represents the content of an SLA to be returned to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sla(SlaContent sla);

        /**
         * <p>
         * Represents the content of an SLA to be returned to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlaContent.Builder} avoiding the need to
         * create one manually via {@link SlaContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlaContent.Builder#build()} is called immediately and its result
         * is passed to {@link #sla(SlaContent)}.
         * 
         * @param sla
         *        a consumer that will call methods on {@link SlaContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sla(SlaContent)
         */
        default Builder sla(Consumer<SlaContent.Builder> sla) {
            return sla(SlaContent.builder().applyMutation(sla).build());
        }

        /**
         * <p>
         * Represents the Amazon Connect case to be created as a related item.
         * </p>
         * 
         * @param connectCase
         *        Represents the Amazon Connect case to be created as a related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCase(ConnectCaseContent connectCase);

        /**
         * <p>
         * Represents the Amazon Connect case to be created as a related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectCaseContent.Builder} avoiding the
         * need to create one manually via {@link ConnectCaseContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectCaseContent.Builder#build()} is called immediately and its
         * result is passed to {@link #connectCase(ConnectCaseContent)}.
         * 
         * @param connectCase
         *        a consumer that will call methods on {@link ConnectCaseContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectCase(ConnectCaseContent)
         */
        default Builder connectCase(Consumer<ConnectCaseContent.Builder> connectCase) {
            return connectCase(ConnectCaseContent.builder().applyMutation(connectCase).build());
        }

        /**
         * <p>
         * Represents the content of a <code>Custom</code> type related item.
         * </p>
         * 
         * @param custom
         *        Represents the content of a <code>Custom</code> type related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(CustomContent custom);

        /**
         * <p>
         * Represents the content of a <code>Custom</code> type related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomContent.Builder} avoiding the need
         * to create one manually via {@link CustomContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomContent.Builder#build()} is called immediately and its
         * result is passed to {@link #custom(CustomContent)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link CustomContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(CustomContent)
         */
        default Builder custom(Consumer<CustomContent.Builder> custom) {
            return custom(CustomContent.builder().applyMutation(custom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContactContent contact;

        private CommentContent comment;

        private FileContent file;

        private SlaContent sla;

        private ConnectCaseContent connectCase;

        private CustomContent custom;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemContent model) {
            contact(model.contact);
            comment(model.comment);
            file(model.file);
            sla(model.sla);
            connectCase(model.connectCase);
            custom(model.custom);
        }

        public final ContactContent.Builder getContact() {
            return contact != null ? contact.toBuilder() : null;
        }

        public final void setContact(ContactContent.BuilderImpl contact) {
            Object oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactContent contact) {
            Object oldValue = this.contact;
            this.contact = contact;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public final CommentContent.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(CommentContent.BuilderImpl comment) {
            Object oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentContent comment) {
            Object oldValue = this.comment;
            this.comment = comment;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final FileContent.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(FileContent.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileContent file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final SlaContent.Builder getSla() {
            return sla != null ? sla.toBuilder() : null;
        }

        public final void setSla(SlaContent.BuilderImpl sla) {
            Object oldValue = this.sla;
            this.sla = sla != null ? sla.build() : null;
            handleUnionValueChange(Type.SLA, oldValue, this.sla);
        }

        @Override
        public final Builder sla(SlaContent sla) {
            Object oldValue = this.sla;
            this.sla = sla;
            handleUnionValueChange(Type.SLA, oldValue, this.sla);
            return this;
        }

        public final ConnectCaseContent.Builder getConnectCase() {
            return connectCase != null ? connectCase.toBuilder() : null;
        }

        public final void setConnectCase(ConnectCaseContent.BuilderImpl connectCase) {
            Object oldValue = this.connectCase;
            this.connectCase = connectCase != null ? connectCase.build() : null;
            handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
        }

        @Override
        public final Builder connectCase(ConnectCaseContent connectCase) {
            Object oldValue = this.connectCase;
            this.connectCase = connectCase;
            handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
            return this;
        }

        public final CustomContent.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(CustomContent.BuilderImpl custom) {
            Object oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(CustomContent custom) {
            Object oldValue = this.custom;
            this.custom = custom;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        @Override
        public RelatedItemContent build() {
            return new RelatedItemContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelatedItemContent#type()
     */
    public enum Type {
        CONTACT,

        COMMENT,

        FILE,

        SLA,

        CONNECT_CASE,

        CUSTOM,

        UNKNOWN_TO_SDK_VERSION
    }
}
