/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The order in which all returned related items should be sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAllRelatedItemsSort implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchAllRelatedItemsSort.Builder, SearchAllRelatedItemsSort> {
    private static final SdkField<String> SORT_PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortProperty").getter(getter(SearchAllRelatedItemsSort::sortPropertyAsString))
            .setter(setter(Builder::sortProperty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortProperty").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(SearchAllRelatedItemsSort::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_PROPERTY_FIELD,
            SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sortProperty;

    private final String sortOrder;

    private SearchAllRelatedItemsSort(BuilderImpl builder) {
        this.sortProperty = builder.sortProperty;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Whether related items should be sorted in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortProperty} will
     * return {@link SearchAllRelatedItemsSortProperty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortPropertyAsString}.
     * </p>
     * 
     * @return Whether related items should be sorted in ascending or descending order.
     * @see SearchAllRelatedItemsSortProperty
     */
    public final SearchAllRelatedItemsSortProperty sortProperty() {
        return SearchAllRelatedItemsSortProperty.fromValue(sortProperty);
    }

    /**
     * <p>
     * Whether related items should be sorted in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortProperty} will
     * return {@link SearchAllRelatedItemsSortProperty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortPropertyAsString}.
     * </p>
     * 
     * @return Whether related items should be sorted in ascending or descending order.
     * @see SearchAllRelatedItemsSortProperty
     */
    public final String sortPropertyAsString() {
        return sortProperty;
    }

    /**
     * <p>
     * Whether related items should be sorted by association time or case ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether related items should be sorted by association time or case ID.
     * @see Order
     */
    public final Order sortOrder() {
        return Order.fromValue(sortOrder);
    }

    /**
     * <p>
     * Whether related items should be sorted by association time or case ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether related items should be sorted by association time or case ID.
     * @see Order
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortPropertyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAllRelatedItemsSort)) {
            return false;
        }
        SearchAllRelatedItemsSort other = (SearchAllRelatedItemsSort) obj;
        return Objects.equals(sortPropertyAsString(), other.sortPropertyAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAllRelatedItemsSort").add("SortProperty", sortPropertyAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortProperty":
            return Optional.ofNullable(clazz.cast(sortPropertyAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sortProperty", SORT_PROPERTY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAllRelatedItemsSort, T> g) {
        return obj -> g.apply((SearchAllRelatedItemsSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchAllRelatedItemsSort> {
        /**
         * <p>
         * Whether related items should be sorted in ascending or descending order.
         * </p>
         * 
         * @param sortProperty
         *        Whether related items should be sorted in ascending or descending order.
         * @see SearchAllRelatedItemsSortProperty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchAllRelatedItemsSortProperty
         */
        Builder sortProperty(String sortProperty);

        /**
         * <p>
         * Whether related items should be sorted in ascending or descending order.
         * </p>
         * 
         * @param sortProperty
         *        Whether related items should be sorted in ascending or descending order.
         * @see SearchAllRelatedItemsSortProperty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchAllRelatedItemsSortProperty
         */
        Builder sortProperty(SearchAllRelatedItemsSortProperty sortProperty);

        /**
         * <p>
         * Whether related items should be sorted by association time or case ID.
         * </p>
         * 
         * @param sortOrder
         *        Whether related items should be sorted by association time or case ID.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Whether related items should be sorted by association time or case ID.
         * </p>
         * 
         * @param sortOrder
         *        Whether related items should be sorted by association time or case ID.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder sortOrder(Order sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String sortProperty;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAllRelatedItemsSort model) {
            sortProperty(model.sortProperty);
            sortOrder(model.sortOrder);
        }

        public final String getSortProperty() {
            return sortProperty;
        }

        public final void setSortProperty(String sortProperty) {
            this.sortProperty = sortProperty;
        }

        @Override
        public final Builder sortProperty(String sortProperty) {
            this.sortProperty = sortProperty;
            return this;
        }

        @Override
        public final Builder sortProperty(SearchAllRelatedItemsSortProperty sortProperty) {
            this.sortProperty(sortProperty == null ? null : sortProperty.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(Order sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public SearchAllRelatedItemsSort build() {
            return new SearchAllRelatedItemsSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
