/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an SLA configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SlaConfiguration.Builder, SlaConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SlaConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SlaConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SlaConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldId").getter(getter(SlaConfiguration::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()).build();

    private static final SdkField<List<FieldValueUnion>> TARGET_FIELD_VALUES_FIELD = SdkField
            .<List<FieldValueUnion>> builder(MarshallingType.LIST)
            .memberName("targetFieldValues")
            .getter(getter(SlaConfiguration::targetFieldValues))
            .setter(setter(Builder::targetFieldValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFieldValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldValueUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldValueUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TARGET_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("targetTime")
            .getter(getter(SlaConfiguration::targetTime))
            .setter(setter(Builder::targetTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime")
            .getter(getter(SlaConfiguration::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            STATUS_FIELD, FIELD_ID_FIELD, TARGET_FIELD_VALUES_FIELD, TARGET_TIME_FIELD, COMPLETION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String status;

    private final String fieldId;

    private final List<FieldValueUnion> targetFieldValues;

    private final Instant targetTime;

    private final Instant completionTime;

    private SlaConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.fieldId = builder.fieldId;
        this.targetFieldValues = builder.targetFieldValues;
        this.targetTime = builder.targetTime;
        this.completionTime = builder.completionTime;
    }

    /**
     * <p>
     * Name of an SLA.
     * </p>
     * 
     * @return Name of an SLA.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Type of SLA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SlaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of SLA.
     * @see SlaType
     */
    public final SlaType type() {
        return SlaType.fromValue(type);
    }

    /**
     * <p>
     * Type of SLA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SlaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of SLA.
     * @see SlaType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Status of an SLA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SlaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of an SLA.
     * @see SlaStatus
     */
    public final SlaStatus status() {
        return SlaStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of an SLA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SlaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of an SLA.
     * @see SlaStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Unique identifier of a field.
     * </p>
     * 
     * @return Unique identifier of a field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetFieldValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetFieldValues() {
        return targetFieldValues != null && !(targetFieldValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of target field values for the fieldId specified in SlaConfiguration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetFieldValues} method.
     * </p>
     * 
     * @return Represents a list of target field values for the fieldId specified in SlaConfiguration.
     */
    public final List<FieldValueUnion> targetFieldValues() {
        return targetFieldValues;
    }

    /**
     * <p>
     * Target time by which an SLA should be completed.
     * </p>
     * 
     * @return Target time by which an SLA should be completed.
     */
    public final Instant targetTime() {
        return targetTime;
    }

    /**
     * <p>
     * Time at which an SLA was completed.
     * </p>
     * 
     * @return Time at which an SLA was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetFieldValues() ? targetFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlaConfiguration)) {
            return false;
        }
        SlaConfiguration other = (SlaConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(fieldId(), other.fieldId())
                && hasTargetFieldValues() == other.hasTargetFieldValues()
                && Objects.equals(targetFieldValues(), other.targetFieldValues())
                && Objects.equals(targetTime(), other.targetTime()) && Objects.equals(completionTime(), other.completionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlaConfiguration").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("Status", statusAsString()).add("FieldId", fieldId())
                .add("TargetFieldValues", hasTargetFieldValues() ? targetFieldValues() : null).add("TargetTime", targetTime())
                .add("CompletionTime", completionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "fieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "targetFieldValues":
            return Optional.ofNullable(clazz.cast(targetFieldValues()));
        case "targetTime":
            return Optional.ofNullable(clazz.cast(targetTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("targetFieldValues", TARGET_FIELD_VALUES_FIELD);
        map.put("targetTime", TARGET_TIME_FIELD);
        map.put("completionTime", COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlaConfiguration, T> g) {
        return obj -> g.apply((SlaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlaConfiguration> {
        /**
         * <p>
         * Name of an SLA.
         * </p>
         * 
         * @param name
         *        Name of an SLA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Type of SLA.
         * </p>
         * 
         * @param type
         *        Type of SLA.
         * @see SlaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of SLA.
         * </p>
         * 
         * @param type
         *        Type of SLA.
         * @see SlaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaType
         */
        Builder type(SlaType type);

        /**
         * <p>
         * Status of an SLA.
         * </p>
         * 
         * @param status
         *        Status of an SLA.
         * @see SlaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of an SLA.
         * </p>
         * 
         * @param status
         *        Status of an SLA.
         * @see SlaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaStatus
         */
        Builder status(SlaStatus status);

        /**
         * <p>
         * Unique identifier of a field.
         * </p>
         * 
         * @param fieldId
         *        Unique identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in SlaConfiguration.
         * </p>
         * 
         * @param targetFieldValues
         *        Represents a list of target field values for the fieldId specified in SlaConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in SlaConfiguration.
         * </p>
         * 
         * @param targetFieldValues
         *        Represents a list of target field values for the fieldId specified in SlaConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFieldValues(FieldValueUnion... targetFieldValues);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in SlaConfiguration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.FieldValueUnion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcases.model.FieldValueUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.FieldValueUnion.Builder#build()} is called
         * immediately and its result is passed to {@link #targetFieldValues(List<FieldValueUnion>)}.
         * 
         * @param targetFieldValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.FieldValueUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetFieldValues(java.util.Collection<FieldValueUnion>)
         */
        Builder targetFieldValues(Consumer<FieldValueUnion.Builder>... targetFieldValues);

        /**
         * <p>
         * Target time by which an SLA should be completed.
         * </p>
         * 
         * @param targetTime
         *        Target time by which an SLA should be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTime(Instant targetTime);

        /**
         * <p>
         * Time at which an SLA was completed.
         * </p>
         * 
         * @param completionTime
         *        Time at which an SLA was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String status;

        private String fieldId;

        private List<FieldValueUnion> targetFieldValues = DefaultSdkAutoConstructList.getInstance();

        private Instant targetTime;

        private Instant completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlaConfiguration model) {
            name(model.name);
            type(model.type);
            status(model.status);
            fieldId(model.fieldId);
            targetFieldValues(model.targetFieldValues);
            targetTime(model.targetTime);
            completionTime(model.completionTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SlaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SlaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<FieldValueUnion.Builder> getTargetFieldValues() {
            List<FieldValueUnion.Builder> result = SlaFieldValueUnionListCopier.copyToBuilder(this.targetFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetFieldValues(Collection<FieldValueUnion.BuilderImpl> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copyFromBuilder(targetFieldValues);
        }

        @Override
        public final Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copy(targetFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(FieldValueUnion... targetFieldValues) {
            targetFieldValues(Arrays.asList(targetFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(Consumer<FieldValueUnion.Builder>... targetFieldValues) {
            targetFieldValues(Stream.of(targetFieldValues).map(c -> FieldValueUnion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getTargetTime() {
            return targetTime;
        }

        public final void setTargetTime(Instant targetTime) {
            this.targetTime = targetTime;
        }

        @Override
        public final Builder targetTime(Instant targetTime) {
            this.targetTime = targetTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        @Override
        public SlaConfiguration build() {
            return new SlaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
