/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An association representing a case rule acting upon a field. In the Amazon Connect admin website, case rules are
 * known as <i>case field conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateRule implements SdkPojo, Serializable, ToCopyableBuilder<TemplateRule.Builder, TemplateRule> {
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleId").getter(getter(TemplateRule::caseRuleId)).setter(setter(Builder::caseRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldId").getter(getter(TemplateRule::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ID_FIELD,
            FIELD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseRuleId;

    private final String fieldId;

    private TemplateRule(BuilderImpl builder) {
        this.caseRuleId = builder.caseRuleId;
        this.fieldId = builder.fieldId;
    }

    /**
     * <p>
     * Unique identifier of a case rule.
     * </p>
     * 
     * @return Unique identifier of a case rule.
     */
    public final String caseRuleId() {
        return caseRuleId;
    }

    /**
     * <p>
     * Unique identifier of a field.
     * </p>
     * 
     * @return Unique identifier of a field.
     */
    public final String fieldId() {
        return fieldId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateRule)) {
            return false;
        }
        TemplateRule other = (TemplateRule) obj;
        return Objects.equals(caseRuleId(), other.caseRuleId()) && Objects.equals(fieldId(), other.fieldId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateRule").add("CaseRuleId", caseRuleId()).add("FieldId", fieldId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseRuleId":
            return Optional.ofNullable(clazz.cast(caseRuleId()));
        case "fieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateRule, T> g) {
        return obj -> g.apply((TemplateRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateRule> {
        /**
         * <p>
         * Unique identifier of a case rule.
         * </p>
         * 
         * @param caseRuleId
         *        Unique identifier of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleId(String caseRuleId);

        /**
         * <p>
         * Unique identifier of a field.
         * </p>
         * 
         * @param fieldId
         *        Unique identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);
    }

    static final class BuilderImpl implements Builder {
        private String caseRuleId;

        private String fieldId;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateRule model) {
            caseRuleId(model.caseRuleId);
            fieldId(model.fieldId);
        }

        public final String getCaseRuleId() {
            return caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        @Override
        public TemplateRule build() {
            return new TemplateRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
