/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.FieldNamespace;
import software.amazon.awssdk.services.connectcases.model.FieldType;
import software.amazon.awssdk.services.connectcases.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFieldResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetFieldResponse> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldId").getter(GetFieldResponse.getter(GetFieldResponse::fieldId)).setter(GetFieldResponse.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetFieldResponse.getter(GetFieldResponse::name)).setter(GetFieldResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FIELD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldArn").getter(GetFieldResponse.getter(GetFieldResponse::fieldArn)).setter(GetFieldResponse.setter(Builder::fieldArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetFieldResponse.getter(GetFieldResponse::description)).setter(GetFieldResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetFieldResponse.getter(GetFieldResponse::typeAsString)).setter(GetFieldResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(GetFieldResponse.getter(GetFieldResponse::namespaceAsString)).setter(GetFieldResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetFieldResponse.getter(GetFieldResponse::tags)).setter(GetFieldResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleted").getter(GetFieldResponse.getter(GetFieldResponse::deleted)).setter(GetFieldResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(GetFieldResponse.getter(GetFieldResponse::createdTime)).setter(GetFieldResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetFieldResponse.getter(GetFieldResponse::lastModifiedTime)).setter(GetFieldResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, NAME_FIELD, FIELD_ARN_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, NAMESPACE_FIELD, TAGS_FIELD, DELETED_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFieldResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String name;
    private final String fieldArn;
    private final String description;
    private final String type;
    private final String namespace;
    private final Map<String, String> tags;
    private final Boolean deleted;
    private final Instant createdTime;
    private final Instant lastModifiedTime;

    private GetFieldResponse(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.name = builder.name;
        this.fieldArn = builder.fieldArn;
        this.description = builder.description;
        this.type = builder.type;
        this.namespace = builder.namespace;
        this.tags = builder.tags;
        this.deleted = builder.deleted;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String name() {
        return this.name;
    }

    public final String fieldArn() {
        return this.fieldArn;
    }

    public final String description() {
        return this.description;
    }

    public final FieldType type() {
        return FieldType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FieldNamespace namespace() {
        return FieldNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean deleted() {
        return this.deleted;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldResponse)) {
            return false;
        }
        GetFieldResponse other = (GetFieldResponse)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fieldArn(), other.fieldArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetFieldResponse").add("FieldId", (Object)this.fieldId()).add("Name", (Object)this.name()).add("FieldArn", (Object)this.fieldArn()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Namespace", (Object)this.namespaceAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Deleted", (Object)this.deleted()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fieldArn": {
                return Optional.ofNullable(clazz.cast(this.fieldArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("fieldArn", FIELD_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFieldResponse, T> g) {
        return obj -> g.apply((GetFieldResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String name;
        private String fieldArn;
        private String description;
        private String type;
        private String namespace;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean deleted;
        private Instant createdTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldResponse model) {
            this.fieldId(model.fieldId);
            this.name(model.name);
            this.fieldArn(model.fieldArn);
            this.description(model.description);
            this.type(model.type);
            this.namespace(model.namespace);
            this.tags(model.tags);
            this.deleted(model.deleted);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFieldArn() {
            return this.fieldArn;
        }

        public final void setFieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
        }

        @Override
        public final Builder fieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(FieldNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public GetFieldResponse build() {
            return new GetFieldResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetFieldResponse> {
        public Builder fieldId(String var1);

        public Builder name(String var1);

        public Builder fieldArn(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(FieldType var1);

        public Builder namespace(String var1);

        public Builder namespace(FieldNamespace var1);

        public Builder tags(Map<String, String> var1);

        public Builder deleted(Boolean var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

