/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the content of a particular audit event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditEvent implements SdkPojo, Serializable, ToCopyableBuilder<AuditEvent.Builder, AuditEvent> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(AuditEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AuditEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> RELATED_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedItemType").getter(getter(AuditEvent::relatedItemTypeAsString))
            .setter(setter(Builder::relatedItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemType").build()).build();

    private static final SdkField<Instant> PERFORMED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("performedTime")
            .getter(getter(AuditEvent::performedTime))
            .setter(setter(Builder::performedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<AuditEventField>> FIELDS_FIELD = SdkField
            .<List<AuditEventField>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(AuditEvent::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditEventField> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditEventField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AuditEventPerformedBy> PERFORMED_BY_FIELD = SdkField
            .<AuditEventPerformedBy> builder(MarshallingType.SDK_POJO).memberName("performedBy")
            .getter(getter(AuditEvent::performedBy)).setter(setter(Builder::performedBy))
            .constructor(AuditEventPerformedBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, TYPE_FIELD,
            RELATED_ITEM_TYPE_FIELD, PERFORMED_TIME_FIELD, FIELDS_FIELD, PERFORMED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String type;

    private final String relatedItemType;

    private final Instant performedTime;

    private final List<AuditEventField> fields;

    private final AuditEventPerformedBy performedBy;

    private AuditEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.type = builder.type;
        this.relatedItemType = builder.relatedItemType;
        this.performedTime = builder.performedTime;
        this.fields = builder.fields;
        this.performedBy = builder.performedBy;
    }

    /**
     * <p>
     * Unique identifier of a case audit history event.
     * </p>
     * 
     * @return Unique identifier of a case audit history event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The Type of an audit history event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AuditEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Type of an audit history event.
     * @see AuditEventType
     */
    public final AuditEventType type() {
        return AuditEventType.fromValue(type);
    }

    /**
     * <p>
     * The Type of an audit history event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AuditEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Type of an audit history event.
     * @see AuditEventType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Type of the related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedItemType}
     * will return {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedItemTypeAsString}.
     * </p>
     * 
     * @return The Type of the related item.
     * @see RelatedItemType
     */
    public final RelatedItemType relatedItemType() {
        return RelatedItemType.fromValue(relatedItemType);
    }

    /**
     * <p>
     * The Type of the related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relatedItemType}
     * will return {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relatedItemTypeAsString}.
     * </p>
     * 
     * @return The Type of the related item.
     * @see RelatedItemType
     */
    public final String relatedItemTypeAsString() {
        return relatedItemType;
    }

    /**
     * <p>
     * Time at which an Audit History event took place.
     * </p>
     * 
     * @return Time at which an Audit History event took place.
     */
    public final Instant performedTime() {
        return performedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Case Audit History event fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A list of Case Audit History event fields.
     */
    public final List<AuditEventField> fields() {
        return fields;
    }

    /**
     * <p>
     * Information of the user which performed the audit.
     * </p>
     * 
     * @return Information of the user which performed the audit.
     */
    public final AuditEventPerformedBy performedBy() {
        return performedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(performedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(relatedItemTypeAsString(), other.relatedItemTypeAsString())
                && Objects.equals(performedTime(), other.performedTime()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && Objects.equals(performedBy(), other.performedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditEvent").add("EventId", eventId()).add("Type", typeAsString())
                .add("RelatedItemType", relatedItemTypeAsString()).add("PerformedTime", performedTime())
                .add("Fields", hasFields() ? fields() : null).add("PerformedBy", performedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "relatedItemType":
            return Optional.ofNullable(clazz.cast(relatedItemTypeAsString()));
        case "performedTime":
            return Optional.ofNullable(clazz.cast(performedTime()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "performedBy":
            return Optional.ofNullable(clazz.cast(performedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventId", EVENT_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("relatedItemType", RELATED_ITEM_TYPE_FIELD);
        map.put("performedTime", PERFORMED_TIME_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("performedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditEvent, T> g) {
        return obj -> g.apply((AuditEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditEvent> {
        /**
         * <p>
         * Unique identifier of a case audit history event.
         * </p>
         * 
         * @param eventId
         *        Unique identifier of a case audit history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The Type of an audit history event.
         * </p>
         * 
         * @param type
         *        The Type of an audit history event.
         * @see AuditEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditEventType
         */
        Builder type(String type);

        /**
         * <p>
         * The Type of an audit history event.
         * </p>
         * 
         * @param type
         *        The Type of an audit history event.
         * @see AuditEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditEventType
         */
        Builder type(AuditEventType type);

        /**
         * <p>
         * The Type of the related item.
         * </p>
         * 
         * @param relatedItemType
         *        The Type of the related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder relatedItemType(String relatedItemType);

        /**
         * <p>
         * The Type of the related item.
         * </p>
         * 
         * @param relatedItemType
         *        The Type of the related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder relatedItemType(RelatedItemType relatedItemType);

        /**
         * <p>
         * Time at which an Audit History event took place.
         * </p>
         * 
         * @param performedTime
         *        Time at which an Audit History event took place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedTime(Instant performedTime);

        /**
         * <p>
         * A list of Case Audit History event fields.
         * </p>
         * 
         * @param fields
         *        A list of Case Audit History event fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<AuditEventField> fields);

        /**
         * <p>
         * A list of Case Audit History event fields.
         * </p>
         * 
         * @param fields
         *        A list of Case Audit History event fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(AuditEventField... fields);

        /**
         * <p>
         * A list of Case Audit History event fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.AuditEventField.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcases.model.AuditEventField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.AuditEventField.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<AuditEventField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.AuditEventField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<AuditEventField>)
         */
        Builder fields(Consumer<AuditEventField.Builder>... fields);

        /**
         * <p>
         * Information of the user which performed the audit.
         * </p>
         * 
         * @param performedBy
         *        Information of the user which performed the audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedBy(AuditEventPerformedBy performedBy);

        /**
         * <p>
         * Information of the user which performed the audit.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditEventPerformedBy.Builder} avoiding
         * the need to create one manually via {@link AuditEventPerformedBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditEventPerformedBy.Builder#build()} is called immediately and
         * its result is passed to {@link #performedBy(AuditEventPerformedBy)}.
         * 
         * @param performedBy
         *        a consumer that will call methods on {@link AuditEventPerformedBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performedBy(AuditEventPerformedBy)
         */
        default Builder performedBy(Consumer<AuditEventPerformedBy.Builder> performedBy) {
            return performedBy(AuditEventPerformedBy.builder().applyMutation(performedBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String type;

        private String relatedItemType;

        private Instant performedTime;

        private List<AuditEventField> fields = DefaultSdkAutoConstructList.getInstance();

        private AuditEventPerformedBy performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEvent model) {
            eventId(model.eventId);
            type(model.type);
            relatedItemType(model.relatedItemType);
            performedTime(model.performedTime);
            fields(model.fields);
            performedBy(model.performedBy);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuditEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRelatedItemType() {
            return relatedItemType;
        }

        public final void setRelatedItemType(String relatedItemType) {
            this.relatedItemType = relatedItemType;
        }

        @Override
        public final Builder relatedItemType(String relatedItemType) {
            this.relatedItemType = relatedItemType;
            return this;
        }

        @Override
        public final Builder relatedItemType(RelatedItemType relatedItemType) {
            this.relatedItemType(relatedItemType == null ? null : relatedItemType.toString());
            return this;
        }

        public final Instant getPerformedTime() {
            return performedTime;
        }

        public final void setPerformedTime(Instant performedTime) {
            this.performedTime = performedTime;
        }

        @Override
        public final Builder performedTime(Instant performedTime) {
            this.performedTime = performedTime;
            return this;
        }

        public final List<AuditEventField.Builder> getFields() {
            List<AuditEventField.Builder> result = AuditEventFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<AuditEventField.BuilderImpl> fields) {
            this.fields = AuditEventFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<AuditEventField> fields) {
            this.fields = AuditEventFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(AuditEventField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<AuditEventField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> AuditEventField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AuditEventPerformedBy.Builder getPerformedBy() {
            return performedBy != null ? performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(AuditEventPerformedBy.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(AuditEventPerformedBy performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        @Override
        public AuditEvent build() {
            return new AuditEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
