/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCaseRuleRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<BatchGetCaseRuleRequest.Builder, BatchGetCaseRuleRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(BatchGetCaseRuleRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<List<CaseRuleIdentifier>> CASE_RULES_FIELD = SdkField
            .<List<CaseRuleIdentifier>> builder(MarshallingType.LIST)
            .memberName("caseRules")
            .getter(getter(BatchGetCaseRuleRequest::caseRules))
            .setter(setter(Builder::caseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseRuleIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseRuleIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            CASE_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final List<CaseRuleIdentifier> caseRules;

    private BatchGetCaseRuleRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.caseRules = builder.caseRules;
    }

    /**
     * <p>
     * Unique identifier of a Cases domain.
     * </p>
     * 
     * @return Unique identifier of a Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaseRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCaseRules() {
        return caseRules != null && !(caseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of case rule identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaseRules} method.
     * </p>
     * 
     * @return A list of case rule identifiers.
     */
    public final List<CaseRuleIdentifier> caseRules() {
        return caseRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaseRules() ? caseRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCaseRuleRequest)) {
            return false;
        }
        BatchGetCaseRuleRequest other = (BatchGetCaseRuleRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && hasCaseRules() == other.hasCaseRules()
                && Objects.equals(caseRules(), other.caseRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCaseRuleRequest").add("DomainId", domainId())
                .add("CaseRules", hasCaseRules() ? caseRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "caseRules":
            return Optional.ofNullable(clazz.cast(caseRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("caseRules", CASE_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCaseRuleRequest, T> g) {
        return obj -> g.apply((BatchGetCaseRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCaseRuleRequest> {
        /**
         * <p>
         * Unique identifier of a Cases domain.
         * </p>
         * 
         * @param domainId
         *        Unique identifier of a Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * A list of case rule identifiers.
         * </p>
         * 
         * @param caseRules
         *        A list of case rule identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRules(Collection<CaseRuleIdentifier> caseRules);

        /**
         * <p>
         * A list of case rule identifiers.
         * </p>
         * 
         * @param caseRules
         *        A list of case rule identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRules(CaseRuleIdentifier... caseRules);

        /**
         * <p>
         * A list of case rule identifiers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #caseRules(List<CaseRuleIdentifier>)}.
         * 
         * @param caseRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseRules(java.util.Collection<CaseRuleIdentifier>)
         */
        Builder caseRules(Consumer<CaseRuleIdentifier.Builder>... caseRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String domainId;

        private List<CaseRuleIdentifier> caseRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCaseRuleRequest model) {
            super(model);
            domainId(model.domainId);
            caseRules(model.caseRules);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<CaseRuleIdentifier.Builder> getCaseRules() {
            List<CaseRuleIdentifier.Builder> result = CaseRuleIdentifierListCopier.copyToBuilder(this.caseRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseRules(Collection<CaseRuleIdentifier.BuilderImpl> caseRules) {
            this.caseRules = CaseRuleIdentifierListCopier.copyFromBuilder(caseRules);
        }

        @Override
        public final Builder caseRules(Collection<CaseRuleIdentifier> caseRules) {
            this.caseRules = CaseRuleIdentifierListCopier.copy(caseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(CaseRuleIdentifier... caseRules) {
            caseRules(Arrays.asList(caseRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(Consumer<CaseRuleIdentifier.Builder>... caseRules) {
            caseRules(Stream.of(caseRules).map(c -> CaseRuleIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCaseRuleRequest build() {
            return new BatchGetCaseRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
