/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Boolean operands for a condition. In the Amazon Connect admin website, case rules are known as <i>case field
 * conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanOperands implements SdkPojo, Serializable, ToCopyableBuilder<BooleanOperands.Builder, BooleanOperands> {
    private static final SdkField<OperandOne> OPERAND_ONE_FIELD = SdkField.<OperandOne> builder(MarshallingType.SDK_POJO)
            .memberName("operandOne").getter(getter(BooleanOperands::operandOne)).setter(setter(Builder::operandOne))
            .constructor(OperandOne::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operandOne").build()).build();

    private static final SdkField<OperandTwo> OPERAND_TWO_FIELD = SdkField.<OperandTwo> builder(MarshallingType.SDK_POJO)
            .memberName("operandTwo").getter(getter(BooleanOperands::operandTwo)).setter(setter(Builder::operandTwo))
            .constructor(OperandTwo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operandTwo").build()).build();

    private static final SdkField<Boolean> RESULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("result").getter(getter(BooleanOperands::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERAND_ONE_FIELD,
            OPERAND_TWO_FIELD, RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OperandOne operandOne;

    private final OperandTwo operandTwo;

    private final Boolean result;

    private BooleanOperands(BuilderImpl builder) {
        this.operandOne = builder.operandOne;
        this.operandTwo = builder.operandTwo;
        this.result = builder.result;
    }

    /**
     * <p>
     * Represents the left hand operand in the condition.
     * </p>
     * 
     * @return Represents the left hand operand in the condition.
     */
    public final OperandOne operandOne() {
        return operandOne;
    }

    /**
     * <p>
     * Represents the right hand operand in the condition.
     * </p>
     * 
     * @return Represents the right hand operand in the condition.
     */
    public final OperandTwo operandTwo() {
        return operandTwo;
    }

    /**
     * <p>
     * The value of the outer rule if the condition evaluates to true.
     * </p>
     * 
     * @return The value of the outer rule if the condition evaluates to true.
     */
    public final Boolean result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operandOne());
        hashCode = 31 * hashCode + Objects.hashCode(operandTwo());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanOperands)) {
            return false;
        }
        BooleanOperands other = (BooleanOperands) obj;
        return Objects.equals(operandOne(), other.operandOne()) && Objects.equals(operandTwo(), other.operandTwo())
                && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BooleanOperands").add("OperandOne", operandOne()).add("OperandTwo", operandTwo())
                .add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operandOne":
            return Optional.ofNullable(clazz.cast(operandOne()));
        case "operandTwo":
            return Optional.ofNullable(clazz.cast(operandTwo()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("operandOne", OPERAND_ONE_FIELD);
        map.put("operandTwo", OPERAND_TWO_FIELD);
        map.put("result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BooleanOperands, T> g) {
        return obj -> g.apply((BooleanOperands) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanOperands> {
        /**
         * <p>
         * Represents the left hand operand in the condition.
         * </p>
         * 
         * @param operandOne
         *        Represents the left hand operand in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandOne(OperandOne operandOne);

        /**
         * <p>
         * Represents the left hand operand in the condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperandOne.Builder} avoiding the need to
         * create one manually via {@link OperandOne#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperandOne.Builder#build()} is called immediately and its result
         * is passed to {@link #operandOne(OperandOne)}.
         * 
         * @param operandOne
         *        a consumer that will call methods on {@link OperandOne.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operandOne(OperandOne)
         */
        default Builder operandOne(Consumer<OperandOne.Builder> operandOne) {
            return operandOne(OperandOne.builder().applyMutation(operandOne).build());
        }

        /**
         * <p>
         * Represents the right hand operand in the condition.
         * </p>
         * 
         * @param operandTwo
         *        Represents the right hand operand in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandTwo(OperandTwo operandTwo);

        /**
         * <p>
         * Represents the right hand operand in the condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperandTwo.Builder} avoiding the need to
         * create one manually via {@link OperandTwo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperandTwo.Builder#build()} is called immediately and its result
         * is passed to {@link #operandTwo(OperandTwo)}.
         * 
         * @param operandTwo
         *        a consumer that will call methods on {@link OperandTwo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operandTwo(OperandTwo)
         */
        default Builder operandTwo(Consumer<OperandTwo.Builder> operandTwo) {
            return operandTwo(OperandTwo.builder().applyMutation(operandTwo).build());
        }

        /**
         * <p>
         * The value of the outer rule if the condition evaluates to true.
         * </p>
         * 
         * @param result
         *        The value of the outer rule if the condition evaluates to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Boolean result);
    }

    static final class BuilderImpl implements Builder {
        private OperandOne operandOne;

        private OperandTwo operandTwo;

        private Boolean result;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanOperands model) {
            operandOne(model.operandOne);
            operandTwo(model.operandTwo);
            result(model.result);
        }

        public final OperandOne.Builder getOperandOne() {
            return operandOne != null ? operandOne.toBuilder() : null;
        }

        public final void setOperandOne(OperandOne.BuilderImpl operandOne) {
            this.operandOne = operandOne != null ? operandOne.build() : null;
        }

        @Override
        public final Builder operandOne(OperandOne operandOne) {
            this.operandOne = operandOne;
            return this;
        }

        public final OperandTwo.Builder getOperandTwo() {
            return operandTwo != null ? operandTwo.toBuilder() : null;
        }

        public final void setOperandTwo(OperandTwo.BuilderImpl operandTwo) {
            this.operandTwo = operandTwo != null ? operandTwo.build() : null;
        }

        @Override
        public final Builder operandTwo(OperandTwo operandTwo) {
            this.operandTwo = operandTwo;
            return this;
        }

        public final Boolean getResult() {
            return result;
        }

        public final void setResult(Boolean result) {
            this.result = result;
        }

        @Override
        public final Builder result(Boolean result) {
            this.result = result;
            return this;
        }

        @Override
        public BooleanOperands build() {
            return new BooleanOperands(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
