/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelatedItemResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<CreateRelatedItemResponse.Builder, CreateRelatedItemResponse> {
    private static final SdkField<String> RELATED_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedItemId").getter(getter(CreateRelatedItemResponse::relatedItemId))
            .setter(setter(Builder::relatedItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemId").build()).build();

    private static final SdkField<String> RELATED_ITEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedItemArn").getter(getter(CreateRelatedItemResponse::relatedItemArn))
            .setter(setter(Builder::relatedItemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_ITEM_ID_FIELD,
            RELATED_ITEM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String relatedItemId;

    private final String relatedItemArn;

    private CreateRelatedItemResponse(BuilderImpl builder) {
        super(builder);
        this.relatedItemId = builder.relatedItemId;
        this.relatedItemArn = builder.relatedItemArn;
    }

    /**
     * <p>
     * The unique identifier of the related item.
     * </p>
     * 
     * @return The unique identifier of the related item.
     */
    public final String relatedItemId() {
        return relatedItemId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the related item.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the related item.
     */
    public final String relatedItemArn() {
        return relatedItemArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemId());
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelatedItemResponse)) {
            return false;
        }
        CreateRelatedItemResponse other = (CreateRelatedItemResponse) obj;
        return Objects.equals(relatedItemId(), other.relatedItemId()) && Objects.equals(relatedItemArn(), other.relatedItemArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRelatedItemResponse").add("RelatedItemId", relatedItemId())
                .add("RelatedItemArn", relatedItemArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relatedItemId":
            return Optional.ofNullable(clazz.cast(relatedItemId()));
        case "relatedItemArn":
            return Optional.ofNullable(clazz.cast(relatedItemArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relatedItemId", RELATED_ITEM_ID_FIELD);
        map.put("relatedItemArn", RELATED_ITEM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelatedItemResponse, T> g) {
        return obj -> g.apply((CreateRelatedItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRelatedItemResponse> {
        /**
         * <p>
         * The unique identifier of the related item.
         * </p>
         * 
         * @param relatedItemId
         *        The unique identifier of the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemId(String relatedItemId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the related item.
         * </p>
         * 
         * @param relatedItemArn
         *        The Amazon Resource Name (ARN) of the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemArn(String relatedItemArn);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private String relatedItemId;

        private String relatedItemArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelatedItemResponse model) {
            super(model);
            relatedItemId(model.relatedItemId);
            relatedItemArn(model.relatedItemArn);
        }

        public final String getRelatedItemId() {
            return relatedItemId;
        }

        public final void setRelatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
        }

        @Override
        public final Builder relatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
            return this;
        }

        public final String getRelatedItemArn() {
            return relatedItemArn;
        }

        public final void setRelatedItemArn(String relatedItemArn) {
            this.relatedItemArn = relatedItemArn;
        }

        @Override
        public final Builder relatedItemArn(String relatedItemArn) {
            this.relatedItemArn = relatedItemArn;
            return this;
        }

        @Override
        public CreateRelatedItemResponse build() {
            return new CreateRelatedItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
