/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for the summarized details of the layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayoutSummary implements SdkPojo, Serializable, ToCopyableBuilder<LayoutSummary.Builder, LayoutSummary> {
    private static final SdkField<String> LAYOUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutId").getter(getter(LayoutSummary::layoutId)).setter(setter(Builder::layoutId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutId").build()).build();

    private static final SdkField<String> LAYOUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutArn").getter(getter(LayoutSummary::layoutArn)).setter(setter(Builder::layoutArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LayoutSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_ID_FIELD,
            LAYOUT_ARN_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String layoutId;

    private final String layoutArn;

    private final String name;

    private LayoutSummary(BuilderImpl builder) {
        this.layoutId = builder.layoutId;
        this.layoutArn = builder.layoutArn;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique identifier for of the layout.
     * </p>
     * 
     * @return The unique identifier for of the layout.
     */
    public final String layoutId() {
        return layoutId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the layout.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the layout.
     */
    public final String layoutArn() {
        return layoutArn;
    }

    /**
     * <p>
     * The name of the layout.
     * </p>
     * 
     * @return The name of the layout.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layoutId());
        hashCode = 31 * hashCode + Objects.hashCode(layoutArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutSummary)) {
            return false;
        }
        LayoutSummary other = (LayoutSummary) obj;
        return Objects.equals(layoutId(), other.layoutId()) && Objects.equals(layoutArn(), other.layoutArn())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayoutSummary").add("LayoutId", layoutId()).add("LayoutArn", layoutArn()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layoutId":
            return Optional.ofNullable(clazz.cast(layoutId()));
        case "layoutArn":
            return Optional.ofNullable(clazz.cast(layoutArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("layoutId", LAYOUT_ID_FIELD);
        map.put("layoutArn", LAYOUT_ARN_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayoutSummary, T> g) {
        return obj -> g.apply((LayoutSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayoutSummary> {
        /**
         * <p>
         * The unique identifier for of the layout.
         * </p>
         * 
         * @param layoutId
         *        The unique identifier for of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutId(String layoutId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the layout.
         * </p>
         * 
         * @param layoutArn
         *        The Amazon Resource Name (ARN) of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutArn(String layoutArn);

        /**
         * <p>
         * The name of the layout.
         * </p>
         * 
         * @param name
         *        The name of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String layoutId;

        private String layoutArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutSummary model) {
            layoutId(model.layoutId);
            layoutArn(model.layoutArn);
            name(model.name);
        }

        public final String getLayoutId() {
            return layoutId;
        }

        public final void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final Builder layoutId(String layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        public final String getLayoutArn() {
            return layoutArn;
        }

        public final void setLayoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
        }

        @Override
        public final Builder layoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public LayoutSummary build() {
            return new LayoutSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
