/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping between a parent field option value and child field option values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParentChildFieldOptionsMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<ParentChildFieldOptionsMapping.Builder, ParentChildFieldOptionsMapping> {
    private static final SdkField<String> PARENT_FIELD_OPTION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentFieldOptionValue").getter(getter(ParentChildFieldOptionsMapping::parentFieldOptionValue))
            .setter(setter(Builder::parentFieldOptionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentFieldOptionValue").build())
            .build();

    private static final SdkField<List<String>> CHILD_FIELD_OPTION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("childFieldOptionValues")
            .getter(getter(ParentChildFieldOptionsMapping::childFieldOptionValues))
            .setter(setter(Builder::childFieldOptionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childFieldOptionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARENT_FIELD_OPTION_VALUE_FIELD, CHILD_FIELD_OPTION_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parentFieldOptionValue;

    private final List<String> childFieldOptionValues;

    private ParentChildFieldOptionsMapping(BuilderImpl builder) {
        this.parentFieldOptionValue = builder.parentFieldOptionValue;
        this.childFieldOptionValues = builder.childFieldOptionValues;
    }

    /**
     * <p>
     * The value in the parent field.
     * </p>
     * 
     * @return The value in the parent field.
     */
    public final String parentFieldOptionValue() {
        return parentFieldOptionValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChildFieldOptionValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChildFieldOptionValues() {
        return childFieldOptionValues != null && !(childFieldOptionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed values in the child field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildFieldOptionValues} method.
     * </p>
     * 
     * @return A list of allowed values in the child field.
     */
    public final List<String> childFieldOptionValues() {
        return childFieldOptionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentFieldOptionValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildFieldOptionValues() ? childFieldOptionValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentChildFieldOptionsMapping)) {
            return false;
        }
        ParentChildFieldOptionsMapping other = (ParentChildFieldOptionsMapping) obj;
        return Objects.equals(parentFieldOptionValue(), other.parentFieldOptionValue())
                && hasChildFieldOptionValues() == other.hasChildFieldOptionValues()
                && Objects.equals(childFieldOptionValues(), other.childFieldOptionValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParentChildFieldOptionsMapping").add("ParentFieldOptionValue", parentFieldOptionValue())
                .add("ChildFieldOptionValues", hasChildFieldOptionValues() ? childFieldOptionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentFieldOptionValue":
            return Optional.ofNullable(clazz.cast(parentFieldOptionValue()));
        case "childFieldOptionValues":
            return Optional.ofNullable(clazz.cast(childFieldOptionValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parentFieldOptionValue", PARENT_FIELD_OPTION_VALUE_FIELD);
        map.put("childFieldOptionValues", CHILD_FIELD_OPTION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentChildFieldOptionsMapping, T> g) {
        return obj -> g.apply((ParentChildFieldOptionsMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParentChildFieldOptionsMapping> {
        /**
         * <p>
         * The value in the parent field.
         * </p>
         * 
         * @param parentFieldOptionValue
         *        The value in the parent field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFieldOptionValue(String parentFieldOptionValue);

        /**
         * <p>
         * A list of allowed values in the child field.
         * </p>
         * 
         * @param childFieldOptionValues
         *        A list of allowed values in the child field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childFieldOptionValues(Collection<String> childFieldOptionValues);

        /**
         * <p>
         * A list of allowed values in the child field.
         * </p>
         * 
         * @param childFieldOptionValues
         *        A list of allowed values in the child field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childFieldOptionValues(String... childFieldOptionValues);
    }

    static final class BuilderImpl implements Builder {
        private String parentFieldOptionValue;

        private List<String> childFieldOptionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParentChildFieldOptionsMapping model) {
            parentFieldOptionValue(model.parentFieldOptionValue);
            childFieldOptionValues(model.childFieldOptionValues);
        }

        public final String getParentFieldOptionValue() {
            return parentFieldOptionValue;
        }

        public final void setParentFieldOptionValue(String parentFieldOptionValue) {
            this.parentFieldOptionValue = parentFieldOptionValue;
        }

        @Override
        public final Builder parentFieldOptionValue(String parentFieldOptionValue) {
            this.parentFieldOptionValue = parentFieldOptionValue;
            return this;
        }

        public final Collection<String> getChildFieldOptionValues() {
            if (childFieldOptionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return childFieldOptionValues;
        }

        public final void setChildFieldOptionValues(Collection<String> childFieldOptionValues) {
            this.childFieldOptionValues = ParentChildFieldOptionsMappingChildFieldOptionValuesListCopier
                    .copy(childFieldOptionValues);
        }

        @Override
        public final Builder childFieldOptionValues(Collection<String> childFieldOptionValues) {
            this.childFieldOptionValues = ParentChildFieldOptionsMappingChildFieldOptionValuesListCopier
                    .copy(childFieldOptionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childFieldOptionValues(String... childFieldOptionValues) {
            childFieldOptionValues(Arrays.asList(childFieldOptionValues));
            return this;
        }

        @Override
        public ParentChildFieldOptionsMapping build() {
            return new ParentChildFieldOptionsMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
