/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchCasesRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<SearchCasesRequest.Builder, SearchCasesRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(SearchCasesRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchCasesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchCasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SEARCH_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchTerm").getter(getter(SearchCasesRequest::searchTerm)).setter(setter(Builder::searchTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTerm").build()).build();

    private static final SdkField<CaseFilter> FILTER_FIELD = SdkField.<CaseFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(SearchCasesRequest::filter)).setter(setter(Builder::filter))
            .constructor(CaseFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<List<Sort>> SORTS_FIELD = SdkField
            .<List<Sort>> builder(MarshallingType.LIST)
            .memberName("sorts")
            .getter(getter(SearchCasesRequest::sorts))
            .setter(setter(Builder::sorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sort> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FieldIdentifier>> FIELDS_FIELD = SdkField
            .<List<FieldIdentifier>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(SearchCasesRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TERM_FIELD, FILTER_FIELD, SORTS_FIELD, FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final Integer maxResults;

    private final String nextToken;

    private final String searchTerm;

    private final CaseFilter filter;

    private final List<Sort> sorts;

    private final List<FieldIdentifier> fields;

    private SearchCasesRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchTerm = builder.searchTerm;
        this.filter = builder.filter;
        this.sorts = builder.sorts;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The maximum number of cases to return. When no value is provided, 25 is the default.
     * </p>
     * 
     * @return The maximum number of cases to return. When no value is provided, 25 is the default.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A word or phrase used to perform a quick search.
     * </p>
     * 
     * @return A word or phrase used to perform a quick search.
     */
    public final String searchTerm() {
        return searchTerm;
    }

    /**
     * <p>
     * A list of filter objects.
     * </p>
     * 
     * @return A list of filter objects.
     */
    public final CaseFilter filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sorts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSorts() {
        return sorts != null && !(sorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of sorts where each sort specifies a field and their sort order to be applied to the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSorts} method.
     * </p>
     * 
     * @return A list of sorts where each sort specifies a field and their sort order to be applied to the results.
     */
    public final List<Sort> sorts() {
        return sorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of field identifiers to be returned as part of the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The list of field identifiers to be returned as part of the response.
     */
    public final List<FieldIdentifier> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(searchTerm());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasSorts() ? sorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesRequest)) {
            return false;
        }
        SearchCasesRequest other = (SearchCasesRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(searchTerm(), other.searchTerm())
                && Objects.equals(filter(), other.filter()) && hasSorts() == other.hasSorts()
                && Objects.equals(sorts(), other.sorts()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchCasesRequest").add("DomainId", domainId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SearchTerm", searchTerm()).add("Filter", filter())
                .add("Sorts", hasSorts() ? sorts() : null).add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "searchTerm":
            return Optional.ofNullable(clazz.cast(searchTerm()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "sorts":
            return Optional.ofNullable(clazz.cast(sorts()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("searchTerm", SEARCH_TERM_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("sorts", SORTS_FIELD);
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCasesRequest, T> g) {
        return obj -> g.apply((SearchCasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchCasesRequest> {
        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The maximum number of cases to return. When no value is provided, 25 is the default.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cases to return. When no value is provided, 25 is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A word or phrase used to perform a quick search.
         * </p>
         * 
         * @param searchTerm
         *        A word or phrase used to perform a quick search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchTerm(String searchTerm);

        /**
         * <p>
         * A list of filter objects.
         * </p>
         * 
         * @param filter
         *        A list of filter objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(CaseFilter filter);

        /**
         * <p>
         * A list of filter objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaseFilter.Builder} avoiding the need to
         * create one manually via {@link CaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(CaseFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link CaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(CaseFilter)
         */
        default Builder filter(Consumer<CaseFilter.Builder> filter) {
            return filter(CaseFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * A list of sorts where each sort specifies a field and their sort order to be applied to the results.
         * </p>
         * 
         * @param sorts
         *        A list of sorts where each sort specifies a field and their sort order to be applied to the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(Collection<Sort> sorts);

        /**
         * <p>
         * A list of sorts where each sort specifies a field and their sort order to be applied to the results.
         * </p>
         * 
         * @param sorts
         *        A list of sorts where each sort specifies a field and their sort order to be applied to the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(Sort... sorts);

        /**
         * <p>
         * A list of sorts where each sort specifies a field and their sort order to be applied to the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.Sort.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.Sort.Builder#build()} is called immediately and its
         * result is passed to {@link #sorts(List<Sort>)}.
         * 
         * @param sorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sorts(java.util.Collection<Sort>)
         */
        Builder sorts(Consumer<Sort.Builder>... sorts);

        /**
         * <p>
         * The list of field identifiers to be returned as part of the response.
         * </p>
         * 
         * @param fields
         *        The list of field identifiers to be returned as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<FieldIdentifier> fields);

        /**
         * <p>
         * The list of field identifiers to be returned as part of the response.
         * </p>
         * 
         * @param fields
         *        The list of field identifiers to be returned as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(FieldIdentifier... fields);

        /**
         * <p>
         * The list of field identifiers to be returned as part of the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<FieldIdentifier>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.FieldIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<FieldIdentifier>)
         */
        Builder fields(Consumer<FieldIdentifier.Builder>... fields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String domainId;

        private Integer maxResults;

        private String nextToken;

        private String searchTerm;

        private CaseFilter filter;

        private List<Sort> sorts = DefaultSdkAutoConstructList.getInstance();

        private List<FieldIdentifier> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCasesRequest model) {
            super(model);
            domainId(model.domainId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            searchTerm(model.searchTerm);
            filter(model.filter);
            sorts(model.sorts);
            fields(model.fields);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchTerm() {
            return searchTerm;
        }

        public final void setSearchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public final Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public final CaseFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(CaseFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(CaseFilter filter) {
            this.filter = filter;
            return this;
        }

        public final List<Sort.Builder> getSorts() {
            List<Sort.Builder> result = SearchCasesRequestSortsListCopier.copyToBuilder(this.sorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSorts(Collection<Sort.BuilderImpl> sorts) {
            this.sorts = SearchCasesRequestSortsListCopier.copyFromBuilder(sorts);
        }

        @Override
        public final Builder sorts(Collection<Sort> sorts) {
            this.sorts = SearchCasesRequestSortsListCopier.copy(sorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Sort... sorts) {
            sorts(Arrays.asList(sorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Consumer<Sort.Builder>... sorts) {
            sorts(Stream.of(sorts).map(c -> Sort.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FieldIdentifier.Builder> getFields() {
            List<FieldIdentifier.Builder> result = SearchCasesRequestFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FieldIdentifier.BuilderImpl> fields) {
            this.fields = SearchCasesRequestFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FieldIdentifier> fields) {
            this.fields = SearchCasesRequestFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FieldIdentifier... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FieldIdentifier.Builder>... fields) {
            fields(Stream.of(fields).map(c -> FieldIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchCasesRequest build() {
            return new SearchCasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
