/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the content of an SLA.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlaInputContent implements SdkPojo, Serializable, ToCopyableBuilder<SlaInputContent.Builder, SlaInputContent> {
    private static final SdkField<SlaInputConfiguration> SLA_INPUT_CONFIGURATION_FIELD = SdkField
            .<SlaInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("slaInputConfiguration")
            .getter(getter(SlaInputContent::slaInputConfiguration)).setter(setter(Builder::slaInputConfiguration))
            .constructor(SlaInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slaInputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SLA_INPUT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SlaInputConfiguration slaInputConfiguration;

    private final Type type;

    private SlaInputContent(BuilderImpl builder) {
        this.slaInputConfiguration = builder.slaInputConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Represents an input SLA configuration.
     * </p>
     * 
     * @return Represents an input SLA configuration.
     */
    public final SlaInputConfiguration slaInputConfiguration() {
        return slaInputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slaInputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlaInputContent)) {
            return false;
        }
        SlaInputContent other = (SlaInputContent) obj;
        return Objects.equals(slaInputConfiguration(), other.slaInputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlaInputContent").add("SlaInputConfiguration", slaInputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slaInputConfiguration":
            return Optional.ofNullable(clazz.cast(slaInputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #slaInputConfiguration()} initialized to the given value.
     *
     * <p>
     * Represents an input SLA configuration.
     * </p>
     * 
     * @param slaInputConfiguration
     *        Represents an input SLA configuration.
     */
    public static SlaInputContent fromSlaInputConfiguration(SlaInputConfiguration slaInputConfiguration) {
        return builder().slaInputConfiguration(slaInputConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #slaInputConfiguration()} initialized to the given value.
     *
     * <p>
     * Represents an input SLA configuration.
     * </p>
     * 
     * @param slaInputConfiguration
     *        Represents an input SLA configuration.
     */
    public static SlaInputContent fromSlaInputConfiguration(Consumer<SlaInputConfiguration.Builder> slaInputConfiguration) {
        SlaInputConfiguration.Builder builder = SlaInputConfiguration.builder();
        slaInputConfiguration.accept(builder);
        return fromSlaInputConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slaInputConfiguration", SLA_INPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlaInputContent, T> g) {
        return obj -> g.apply((SlaInputContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlaInputContent> {
        /**
         * <p>
         * Represents an input SLA configuration.
         * </p>
         * 
         * @param slaInputConfiguration
         *        Represents an input SLA configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slaInputConfiguration(SlaInputConfiguration slaInputConfiguration);

        /**
         * <p>
         * Represents an input SLA configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlaInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link SlaInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlaInputConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #slaInputConfiguration(SlaInputConfiguration)}.
         * 
         * @param slaInputConfiguration
         *        a consumer that will call methods on {@link SlaInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slaInputConfiguration(SlaInputConfiguration)
         */
        default Builder slaInputConfiguration(Consumer<SlaInputConfiguration.Builder> slaInputConfiguration) {
            return slaInputConfiguration(SlaInputConfiguration.builder().applyMutation(slaInputConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlaInputConfiguration slaInputConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SlaInputContent model) {
            slaInputConfiguration(model.slaInputConfiguration);
        }

        public final SlaInputConfiguration.Builder getSlaInputConfiguration() {
            return slaInputConfiguration != null ? slaInputConfiguration.toBuilder() : null;
        }

        public final void setSlaInputConfiguration(SlaInputConfiguration.BuilderImpl slaInputConfiguration) {
            Object oldValue = this.slaInputConfiguration;
            this.slaInputConfiguration = slaInputConfiguration != null ? slaInputConfiguration.build() : null;
            handleUnionValueChange(Type.SLA_INPUT_CONFIGURATION, oldValue, this.slaInputConfiguration);
        }

        @Override
        public final Builder slaInputConfiguration(SlaInputConfiguration slaInputConfiguration) {
            Object oldValue = this.slaInputConfiguration;
            this.slaInputConfiguration = slaInputConfiguration;
            handleUnionValueChange(Type.SLA_INPUT_CONFIGURATION, oldValue, this.slaInputConfiguration);
            return this;
        }

        @Override
        public SlaInputContent build() {
            return new SlaInputContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SlaInputContent#type()
     */
    public enum Type {
        SLA_INPUT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
