/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcontactlens.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcontactlens.model.ConnectContactLensResponse;
import software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegment;
import software.amazon.awssdk.services.connectcontactlens.model.RealtimeContactAnalysisSegmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRealtimeContactAnalysisSegmentsResponse
extends ConnectContactLensResponse
implements ToCopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsResponse> {
    private static final SdkField<List<RealtimeContactAnalysisSegment>> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Segments").getter(ListRealtimeContactAnalysisSegmentsResponse.getter(ListRealtimeContactAnalysisSegmentsResponse::segments)).setter(ListRealtimeContactAnalysisSegmentsResponse.setter(Builder::segments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealtimeContactAnalysisSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRealtimeContactAnalysisSegmentsResponse.getter(ListRealtimeContactAnalysisSegmentsResponse::nextToken)).setter(ListRealtimeContactAnalysisSegmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RealtimeContactAnalysisSegment> segments;
    private final String nextToken;

    private ListRealtimeContactAnalysisSegmentsResponse(BuilderImpl builder) {
        super(builder);
        this.segments = builder.segments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSegments() {
        return this.segments != null && !(this.segments instanceof SdkAutoConstructList);
    }

    public List<RealtimeContactAnalysisSegment> segments() {
        return this.segments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegments() ? this.segments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeContactAnalysisSegmentsResponse)) {
            return false;
        }
        ListRealtimeContactAnalysisSegmentsResponse other = (ListRealtimeContactAnalysisSegmentsResponse)((Object)obj);
        return this.hasSegments() == other.hasSegments() && Objects.equals(this.segments(), other.segments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRealtimeContactAnalysisSegmentsResponse").add("Segments", this.hasSegments() ? this.segments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeContactAnalysisSegmentsResponse, T> g) {
        return obj -> g.apply((ListRealtimeContactAnalysisSegmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectContactLensResponse.BuilderImpl
    implements Builder {
        private List<RealtimeContactAnalysisSegment> segments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeContactAnalysisSegmentsResponse model) {
            super(model);
            this.segments(model.segments);
            this.nextToken(model.nextToken);
        }

        public final Collection<RealtimeContactAnalysisSegment.Builder> getSegments() {
            if (this.segments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.segments != null ? (Collection)this.segments.stream().map(RealtimeContactAnalysisSegment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder segments(Collection<RealtimeContactAnalysisSegment> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(RealtimeContactAnalysisSegment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder> ... segments) {
            this.segments(Stream.of(segments).map(c -> (RealtimeContactAnalysisSegment)((RealtimeContactAnalysisSegment.Builder)RealtimeContactAnalysisSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSegments(Collection<RealtimeContactAnalysisSegment.BuilderImpl> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copyFromBuilder(segments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRealtimeContactAnalysisSegmentsResponse build() {
            return new ListRealtimeContactAnalysisSegmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectContactLensResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsResponse> {
        public Builder segments(Collection<RealtimeContactAnalysisSegment> var1);

        public Builder segments(RealtimeContactAnalysisSegment ... var1);

        public Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

